/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.jpda;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Objects;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class SmartSteppingCallback {
    public abstract void initFilter(SmartSteppingFilter var1);

    public abstract boolean stopHere(ContextProvider var1, JPDAThread var2, SmartSteppingFilter var3);

    public StopOrStep stopAt(ContextProvider lookupProvider, CallStackFrame frame, SmartSteppingFilter f) {
        int depth = frame.getFrameDepth();
        if (depth > 0) {
            throw new UnsupportedOperationException("Not supporting frames with depth > 0");
        }
        boolean stop = this.stopHere(lookupProvider, frame.getThread(), f);
        return stop ? StopOrStep.stop() : StopOrStep.skip();
    }

    public static final class StopOrStep {
        private static final StopOrStep STOP = new StopOrStep(true, 0, 0);
        private static final StopOrStep SKIP = new StopOrStep(false, 0, 0);
        private final boolean stop;
        private final int stepSize;
        private final int stepDepth;

        public static StopOrStep stop() {
            return STOP;
        }

        public static StopOrStep skip() {
            return SKIP;
        }

        public static StopOrStep step(int stepSize, int stepDepth) {
            return new StopOrStep(false, stepSize, stepDepth);
        }

        private StopOrStep(boolean stop, int stepSize, int stepDepth) {
            this.stop = stop;
            switch (stepSize) {
                case -2: 
                case -1: 
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong step size: " + stepSize);
                }
            }
            switch (stepDepth) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong step depth: " + stepDepth);
                }
            }
            this.stepSize = stepSize;
            this.stepDepth = stepDepth;
        }

        public boolean isStop() {
            return this.stop;
        }

        public int getStepSize() {
            return this.stepSize;
        }

        public int getStepDepth() {
            return this.stepDepth;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopOrStep)) {
                return false;
            }
            StopOrStep ss = (StopOrStep)obj;
            return this.stop == ss.stop && this.stepSize == ss.stepSize && this.stepDepth == ss.stepDepth;
        }

        public int hashCode() {
            return Objects.hash(this.stop, this.stepSize, this.stepDepth);
        }

        public String toString() {
            return "StopOrStep[" + this.stop + "," + this.stepSize + "," + this.stepDepth + "]";
        }
    }

    static class ContextAware
    extends SmartSteppingCallback
    implements ContextAwareService<SmartSteppingCallback> {
        private String serviceName;

        private ContextAware(String serviceName) {
            this.serviceName = serviceName;
        }

        public SmartSteppingCallback forContext(ContextProvider context) {
            return (SmartSteppingCallback)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)context);
        }

        @Override
        public void initFilter(SmartSteppingFilter f) {
            assert (false);
        }

        @Override
        public boolean stopHere(ContextProvider lookupProvider, JPDAThread thread, SmartSteppingFilter f) {
            assert (false);
            throw new UnsupportedOperationException("Not supported.");
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            return new ContextAware(serviceName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

