/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.CommonServerSupport;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraInstanceProvider;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.admin.CommandGetProperty;
import org.netbeans.modules.payara.tooling.admin.CommandSetProperty;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

public class EnableComet
implements Runnable {
    private static final Logger LOGGER = PayaraLogger.get(CommonServerSupport.class);
    private final PayaraInstance instance;

    public EnableComet(PayaraInstance instance) {
        this.instance = instance;
    }

    @Override
    public void run() {
        String propertiesPattern = "*.comet-support-enabled";
        try {
            ResultMap result = CommandGetProperty.getProperties((PayaraServer)this.instance, (String)propertiesPattern, (long)10000L);
            if (result.getState() == TaskState.COMPLETED) {
                String newValue = this.instance.getProperty("v3.grizzly.cometSupport");
                if (null == newValue || newValue.trim().length() < 1) {
                    newValue = "false";
                }
                for (Map.Entry entry : result.getValue().entrySet()) {
                    String key = (String)entry.getKey();
                    if (null == key || key.contains("admin-listener")) continue;
                    CommandSetProperty command = PayaraInstanceProvider.getProvider().getCommandFactory().getSetPropertyCommand(key, newValue);
                    ResultString resultString = CommandSetProperty.setProperty((PayaraServer)this.instance, (CommandSetProperty)command, (long)10000L);
                }
            }
        }
        catch (PayaraIdeException gfie) {
            LOGGER.log(Level.INFO, "Could not get comment-support-enabeld value.", gfie);
        }
    }
}

