/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAArrayType;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.modules.debugger.jpda.heapwalk.FieldValueImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.HeapImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.InstanceImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.ObjectFieldValueImpl;
import org.openide.ErrorManager;

public class JavaClassImpl
implements JavaClass {
    private JPDAClassType classType;
    private long instanceCount = -1L;
    private HeapImpl heap;
    private String className;

    public JavaClassImpl(HeapImpl heap, JPDAClassType classType) {
        if (classType == null) {
            throw new NullPointerException("classType == null");
        }
        this.classType = classType;
        this.heap = heap;
    }

    public JavaClassImpl(String className) {
        this.className = className;
    }

    public JavaClassImpl(HeapImpl heap, JPDAClassType classType, long instanceCount) {
        this.classType = classType;
        this.instanceCount = instanceCount;
        this.heap = heap;
    }

    public long getJavaClassId() {
        if (this.classType != null) {
            return this.classType.hashCode();
        }
        return this.className.hashCode();
    }

    public Instance getClassLoader() {
        if (this.classType != null) {
            return InstanceImpl.createInstance(this.heap, this.classType.getClassLoader());
        }
        return null;
    }

    public JavaClass getSuperClass() {
        Super superClass;
        if (this.classType != null && (superClass = this.classType.getSuperClass()) != null) {
            return new JavaClassImpl(this.heap, superClass.getClassType());
        }
        return null;
    }

    public int getInstanceSize() {
        return -1;
    }

    public long getAllInstancesSize() {
        return -1L;
    }

    public List<org.netbeans.lib.profiler.heap.Field> getFields() {
        return Collections.emptyList();
    }

    public List<FieldValue> getStaticFieldValues() {
        if (this.classType == null) {
            return Collections.emptyList();
        }
        List refFields = this.classType.staticFields();
        ArrayList<FieldValue> fields = new ArrayList<FieldValue>(refFields.size());
        for (Field field : refFields) {
            if (!field.isStatic()) continue;
            if (field instanceof ObjectVariable) {
                Instance instance = ((ObjectVariable)field).getUniqueID() == 0L ? null : InstanceImpl.createInstance(this.heap, (ObjectVariable)field);
                fields.add(new ObjectFieldValueImpl(this.heap, null, field, instance));
                continue;
            }
            fields.add(new FieldValueImpl(this.heap, null, field));
        }
        return fields;
    }

    public Object getValueOfStaticField(String name) {
        for (FieldValue fieldValue : this.getStaticFieldValues()) {
            if (!fieldValue.getField().getName().equals(name)) continue;
            if (fieldValue instanceof ObjectFieldValue) {
                return ((ObjectFieldValue)fieldValue).getInstance();
            }
            return fieldValue.getValue();
        }
        return null;
    }

    public List<Instance> getInstances() {
        if (this.classType == null) {
            return Collections.emptyList();
        }
        List typeInstances = this.classType.getInstances(0L);
        ArrayList<Instance> instances = new ArrayList<Instance>(typeInstances.size());
        for (ObjectVariable inst : typeInstances) {
            Instance instance = InstanceImpl.createInstance(this.heap, inst);
            instances.add(instance);
        }
        return instances;
    }

    public Iterator getInstancesIterator() {
        return this.getInstances().iterator();
    }

    public int getInstancesCount() {
        if (this.instanceCount != -1L) {
            return (int)this.instanceCount;
        }
        if (this.classType == null) {
            return 0;
        }
        return (int)this.classType.getInstanceCount();
    }

    public String getName() {
        if (this.classType != null) {
            return this.classType.getName();
        }
        return this.className;
    }

    public boolean isArray() {
        return this.classType instanceof JPDAArrayType;
    }

    public List<JavaClass> getSubClasses() {
        if (this.classType != null) {
            try {
                Method getSubClassesMethod = this.classType.getClass().getMethod("getSubClasses", new Class[0]);
                List subclasses = (List)getSubClassesMethod.invoke((Object)this.classType, new Object[0]);
                if (subclasses.size() > 0) {
                    long[] counts = this.heap.getDebugger().getInstanceCounts(subclasses);
                    ArrayList<JavaClassImpl> subClasses = new ArrayList<JavaClassImpl>(subclasses.size());
                    int i = 0;
                    for (JPDAClassType subclass : subclasses) {
                        subClasses.add(new JavaClassImpl(this.heap, subclass, counts[i++]));
                    }
                    return Collections.unmodifiableList(subClasses);
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return Collections.emptyList();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaClassImpl)) {
            return false;
        }
        JavaClassImpl jc = (JavaClassImpl)obj;
        if (this.classType != null && this.classType.equals((Object)jc.classType)) {
            return true;
        }
        return this.className != null && this.className.equals(jc.className);
    }

    public int hashCode() {
        if (this.classType != null) {
            return this.classType.hashCode();
        }
        return this.className.hashCode() + 1024;
    }

    public long getRetainedSizeByClass() {
        return -1L;
    }
}

