/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans;

import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModelFactory;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class MetaModelSupport {
    private Project myProject;
    private static WeakHashMap<Project, MetadataModel<WebBeansModel>> MODELS = new WeakHashMap();

    public MetaModelSupport(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataModel<WebBeansModel> getMetaModel() {
        WeakHashMap<Project, MetadataModel<WebBeansModel>> weakHashMap = MODELS;
        synchronized (weakHashMap) {
            MetadataModel<WebBeansModel> metadataModel = MODELS.get(this.myProject);
            if (metadataModel != null) {
                return metadataModel;
            }
            ClassPath boot = this.getClassPath("classpath/boot");
            ClassPath compile = this.getClassPath("classpath/compile");
            ClassPath src = this.getClassPath("classpath/source");
            if (boot == null || compile == null || src == null) {
                return null;
            }
            ModelUnit modelUnit = ModelUnit.create(boot, compile, src, this.myProject);
            metadataModel = WebBeansModelFactory.getMetaModel(modelUnit);
            MODELS.put(this.myProject, metadataModel);
            return metadataModel;
        }
    }

    public ClassPath getClassPath(String type) {
        FileObject rootFolder;
        ClassPathProvider provider = (ClassPathProvider)this.getProject().getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = (Sources)this.getProject().getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        SourceGroup[] webGroup = sources.getSourceGroups("web_inf");
        ClassPath[] paths = new ClassPath[sourceGroups.length + webGroup.length];
        int i = 0;
        for (SourceGroup sourceGroup : sourceGroups) {
            rootFolder = sourceGroup.getRootFolder();
            paths[i] = provider.findClassPath(rootFolder, type);
            ++i;
        }
        for (SourceGroup sourceGroup : webGroup) {
            rootFolder = sourceGroup.getRootFolder();
            paths[i] = provider.findClassPath(rootFolder, type);
            ++i;
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])paths);
    }

    private Project getProject() {
        return this.myProject;
    }
}

