/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.netbeans.modules.hudson.ui.actions.ProjectRenderer;
import org.netbeans.modules.hudson.ui.spi.ProjectHudsonProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ProjectAssociationAction
extends AbstractAction {
    private final ProjectHudsonProvider.Association assoc;
    private final Project alreadyAssociatedProject;

    public ProjectAssociationAction(HudsonJob job) {
        this.assoc = ProjectHudsonProvider.Association.forJob(job);
        this.alreadyAssociatedProject = ProjectHudsonProvider.getDefault().findAssociatedProject(this.assoc);
        if (this.alreadyAssociatedProject == null) {
            this.putValue("Name", Bundle.ProjectAssociationAction_associate());
        } else {
            this.putValue("Name", Bundle.ProjectAssociationAction_dissociate(ProjectUtils.getInformation((Project)this.alreadyAssociatedProject).getDisplayName()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.alreadyAssociatedProject == null) {
            TreeSet<Project> projects = new TreeSet<Project>(ProjectRenderer.comparator());
            projects.addAll(Arrays.asList(OpenProjects.getDefault().getOpenProjects()));
            if (projects.isEmpty()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ProjectAssociationAction_open_some_projects(), 1));
                return;
            }
            JComboBox<Project> box = new JComboBox<Project>(new DefaultComboBoxModel<Project>(projects.toArray(new Project[0])));
            box.setRenderer(new ProjectRenderer());
            if (DialogDisplayer.getDefault().notify(new NotifyDescriptor(box, Bundle.ProjectAssociationAction_title_select_project(), 2, -1, null, null)) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            if (!ProjectHudsonProvider.getDefault().recordAssociation((Project)box.getSelectedItem(), this.assoc)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ProjectAssociationAction_could_not_associate(), 2));
            }
        } else if (!ProjectHudsonProvider.getDefault().recordAssociation(this.alreadyAssociatedProject, null)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ProjectAssociationAction_could_not_dissociate(), 2));
        }
    }
}

