/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.DAPFrame;
import org.netbeans.modules.lsp.client.debugger.DAPStackTraceAnnotationHolder;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public final class DAPThread
implements DebuggingView.DVThread {
    public static final String PROP_STACK = "stack";
    public static final String PROP_CURRENT_FRAME = "currentFrame";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final DAPDebugger debugger;
    private final int id;
    private final AtomicReference<DAPFrame> currentFrame = new AtomicReference();
    private final AtomicReference<DAPFrame[]> currentStack = new AtomicReference();
    private Status status;
    private String name;

    public DAPThread(DAPDebugger debugger, int id) {
        this.debugger = debugger;
        this.id = id;
        this.name = "Thread #" + id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSuspended() {
        return this.status == Status.SUSPENDED;
    }

    public void resume() {
    }

    public void suspend() {
    }

    public void makeCurrent() {
    }

    public DebuggingView.DVSupport getDVSupport() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<DebuggingView.DVThread> getLockerThreads() {
        return null;
    }

    public void resumeBlockingThreads() {
    }

    public Breakpoint getCurrentBreakpoint() {
        return null;
    }

    public boolean isInStep() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public void setStack(DAPFrame[] frames) {
        this.currentStack.set(frames);
        if (frames.length > 0) {
            this.currentFrame.set(frames[0]);
        } else {
            this.currentFrame.set(null);
        }
        this.refreshAnnotations();
        this.pcs.firePropertyChange(PROP_STACK, null, frames);
        this.pcs.firePropertyChange(PROP_CURRENT_FRAME, null, this.getCurrentFrame());
    }

    public DAPFrame[] getStack() {
        return this.currentStack.get();
    }

    public void setStatus(Status status) {
        boolean wasSuspended = this.isSuspended();
        this.status = status;
        boolean isSuspended = this.isSuspended();
        if (wasSuspended != isSuspended) {
            this.pcs.firePropertyChange("suspended", wasSuspended, isSuspended);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public String getDetails() {
        return null;
    }

    public DAPFrame getCurrentFrame() {
        return this.currentFrame.get();
    }

    public void setCurrentFrame(DAPFrame frame) {
        this.currentFrame.set(frame);
        this.refreshAnnotations();
        this.pcs.firePropertyChange(PROP_CURRENT_FRAME, null, this.getCurrentFrame());
    }

    public Line getCurrentLine() {
        DAPFrame frame = this.currentFrame.get();
        return frame != null ? frame.location() : null;
    }

    private void refreshAnnotations() {
        DAPFrame[] frames = this.getStack();
        if (frames.length == 0) {
            DAPStackTraceAnnotationHolder.unmarkCurrent();
            return;
        }
        Line currentLine = this.getCurrentLine();
        ArrayList<Line> stack = new ArrayList<Line>();
        if (currentLine != null) {
            stack.add(currentLine);
        }
        Arrays.stream(frames).map(f -> f.location()).filter(l -> l != null).filter(l -> l != currentLine).forEach(stack::add);
        DAPStackTraceAnnotationHolder.markCurrent((Annotatable[])stack.toArray(Line[]::new));
    }

    public static enum Status {
        CREATED,
        RUNNING,
        SUSPENDED,
        EXITED;

    }
}

