/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;

final class ScanLocalVars
extends ErrorAwareTreePathScanner<Void, Void> {
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.RESOURCE_VARIABLE);
    private static final Set<ElementKind> FIELDS = EnumSet.of(ElementKind.FIELD);
    private final CompilationInfo info;
    private boolean hasReturns = false;
    private final Set<VariableElement> declaredVariables = new HashSet<VariableElement>();
    private final Set<VariableElement> referencedVariables = new LinkedHashSet<VariableElement>();
    private final StatementTree lastStatement;
    private final Set<TypeMirror> returnTypes = new HashSet<TypeMirror>();
    private int nesting;

    public ScanLocalVars(CompilationInfo info, StatementTree lastStatement) {
        this.info = info;
        this.lastStatement = lastStatement;
    }

    public Void visitLambdaExpression(LambdaExpressionTree node, Void p) {
        ++this.nesting;
        super.visitLambdaExpression(node, (Object)p);
        --this.nesting;
        return null;
    }

    public Void visitNewClass(NewClassTree node, Void p) {
        ++this.nesting;
        super.visitNewClass(node, (Object)p);
        --this.nesting;
        return null;
    }

    public Void visitClass(ClassTree node, Void p) {
        ++this.nesting;
        super.visitClass(node, (Object)p);
        --this.nesting;
        return null;
    }

    public Void visitVariable(VariableTree node, Void p) {
        Element e = this.info.getTrees().getElement(this.getCurrentPath());
        if (e != null && (LOCAL_VARIABLES.contains((Object)e.getKind()) || FIELDS.contains((Object)e.getKind()))) {
            this.declaredVariables.add((VariableElement)e);
        }
        return (Void)super.visitVariable(node, (Object)p);
    }

    public Void visitIdentifier(IdentifierTree node, Void p) {
        Element e = this.info.getTrees().getElement(this.getCurrentPath());
        if (e != null && (LOCAL_VARIABLES.contains((Object)e.getKind()) || FIELDS.contains((Object)e.getKind()) && e.getModifiers().contains((Object)Modifier.PRIVATE)) && !this.declaredVariables.contains((VariableElement)e)) {
            this.referencedVariables.add((VariableElement)e);
        }
        return (Void)super.visitIdentifier(node, (Object)p);
    }

    private boolean isMethodCode() {
        return this.nesting == 0;
    }

    public Void visitReturn(ReturnTree node, Void p) {
        if (this.isMethodCode()) {
            this.hasReturns = true;
            TypeMirror type = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (type != null && type.getKind() != TypeKind.ERROR) {
                this.returnTypes.add(type);
            } else {
                TypeElement object = this.info.getElements().getTypeElement("java.lang.Object");
                if (object != null) {
                    this.returnTypes.add(object.asType());
                }
            }
        }
        return (Void)super.visitReturn(node, (Object)p);
    }

    public Void visitExpressionStatement(ExpressionStatementTree node, Void p) {
        if (node == this.lastStatement && !this.hasReturns) {
            ExpressionTree expression = node.getExpression();
            TypeMirror type = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), expression));
            if (type != null && TypeKind.ERROR != type.getKind()) {
                this.returnTypes.add(type);
            }
        }
        return (Void)super.visitExpressionStatement(node, (Object)p);
    }

    Set<VariableElement> getReferencedVariables() {
        return this.referencedVariables;
    }

    String getReturnType() {
        if (this.returnTypes.isEmpty()) {
            return null;
        }
        return this.returnTypes.iterator().next().toString();
    }

    TypeMirror getReturnTypeMirror() {
        if (this.returnTypes.isEmpty()) {
            return null;
        }
        return this.returnTypes.iterator().next();
    }

    boolean hasReturns() {
        return this.hasReturns;
    }
}

