/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.document;

import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wsdl.document.Documentation;
import com.sun.tools.ws.wsdl.document.Kinds;
import com.sun.tools.ws.wsdl.document.MessagePart;
import com.sun.tools.ws.wsdl.document.WSDLConstants;
import com.sun.tools.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.ws.wsdl.framework.Defining;
import com.sun.tools.ws.wsdl.framework.EntityAction;
import com.sun.tools.ws.wsdl.framework.GlobalEntity;
import com.sun.tools.ws.wsdl.framework.Kind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

public class Message
extends GlobalEntity {
    private Documentation _documentation;
    private List<MessagePart> _parts = new ArrayList<MessagePart>();
    private Map<String, MessagePart> _partsByName = new HashMap<String, MessagePart>();

    public Message(Defining defining, Locator locator, ErrorReceiver errReceiver) {
        super(defining, locator, errReceiver);
    }

    public void add(MessagePart part) {
        if (this._partsByName.get(part.getName()) != null) {
            this.errorReceiver.error(part.getLocator(), WsdlMessages.VALIDATION_DUPLICATE_PART_NAME(this.getName(), part.getName()));
            throw new AbortException();
        }
        if (part.getDescriptor() != null && part.getDescriptorKind() != null) {
            this._partsByName.put(part.getName(), part);
            this._parts.add(part);
        } else {
            this.errorReceiver.warning(part.getLocator(), WsdlMessages.PARSING_ELEMENT_OR_TYPE_REQUIRED(part.getName()));
        }
    }

    public Iterator<MessagePart> parts() {
        return this._parts.iterator();
    }

    public List<MessagePart> getParts() {
        return this._parts;
    }

    public MessagePart getPart(String name) {
        return this._partsByName.get(name);
    }

    public int numParts() {
        return this._parts.size();
    }

    @Override
    public Kind getKind() {
        return Kinds.MESSAGE;
    }

    @Override
    public QName getElementName() {
        return WSDLConstants.QNAME_MESSAGE;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction action) {
        super.withAllSubEntitiesDo(action);
        Iterator<MessagePart> iter = this._parts.iterator();
        while (iter.hasNext()) {
            action.perform(iter.next());
        }
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        Iterator<MessagePart> iter = this._parts.iterator();
        while (iter.hasNext()) {
            iter.next().accept(visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public void validateThis() {
        if (this.getName() == null) {
            this.errorReceiver.error(this.getLocator(), WsdlMessages.VALIDATION_MISSING_REQUIRED_ATTRIBUTE("name", "wsdl:message"));
            throw new AbortException();
        }
    }
}

