/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.SaasClientJavaAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.WadlSaasEx;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaUtil;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.openide.filesystems.FileObject;

public class RestClientPojoCodeGenerator
extends SaasClientCodeGenerator {
    private JavaSource targetSource;
    private FileObject saasServiceFile = null;
    private JavaSource saasServiceJS = null;
    private FileObject serviceFolder = null;
    private SaasClientJavaAuthenticationGenerator authGen;

    public RestClientPojoCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.JAVA_CLIENT);
    }

    public boolean canAccept(SaasMethod method, Document doc) {
        return SaasBean.canAccept((SaasMethod)method, WadlSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && Util.isJava((Document)doc);
    }

    public void init(SaasMethod m, Document doc) throws IOException {
        this.init(m, new RestClientSaasBean((WadlSaasMethod)m), doc);
    }

    public void init(SaasMethod m, RestClientSaasBean saasBean, Document doc) throws IOException {
        super.init(m, doc);
        this.setBean((SaasBean)saasBean);
        this.targetSource = JavaSource.forFileObject((FileObject)this.getTargetFile());
        String packageName = JavaSourceHelper.getPackageName(this.targetSource);
        this.getBean().setPackageName(packageName);
        this.serviceFolder = null;
        this.saasServiceFile = SourceGroupSupport.findJavaSourceFile(this.getProject(), this.getBean().getSaasServiceName());
        if (this.saasServiceFile != null) {
            this.saasServiceJS = JavaSource.forFileObject((FileObject)this.saasServiceFile);
        }
        this.authGen = new SaasClientJavaAuthenticationGenerator((SaasBean)this.getBean(), this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
        this.getBean();
        this.authGen.setAuthenticationProfile(RestClientSaasBean.getProfile((SaasMethod)m, (Constants.DropFileType)this.getDropFileType()));
        this.authGen.setDropFileType(this.getDropFileType());
    }

    protected JavaSource getTargetSource() {
        return this.targetSource;
    }

    public SaasClientAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    public JavaSource getSaasServiceSource() {
        return this.saasServiceJS;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            SourceGroup[] srcGrps = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            this.serviceFolder = SourceGroupSupport.getFolderForPackage(srcGrps[0], this.getBean().getSaasServicePackageName(), true);
        }
        return this.serviceFolder;
    }

    public RestClientSaasBean getBean() {
        return (RestClientSaasBean)super.getBean();
    }

    protected void preGenerate() throws IOException {
        super.preGenerate();
        this.createRestConnectionFile(this.getProject());
        if (this.getBean().getMethod().getSaas().getLibraryJars() == null) {
            WadlSaasEx ex = new WadlSaasEx(this.getBean().getMethod().getSaas());
            this.getBean().getMethod().getSaas().setLibraryJars(ex.getLibraryJars());
            this.getBean().getMethod().getSaas().setJaxbSourceJars(ex.getJaxbSourceJars());
        }
        if (this.getBean().getMethod().getSaas().getLibraryJars().size() > 0) {
            JavaUtil.addClientJars((SaasBean)this.getBean(), this.getProject(), null);
        }
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.createSaasServiceClass();
        this.addSaasServiceMethod();
        this.addImportsToSaasService();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.setJaxbWrapper();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.emptyList());
    }

    private void setJaxbWrapper() {
        this.getBean();
        List repTypesFromWadl = RestClientSaasBean.findRepresentationTypes((WadlSaasMethod)this.getBean().getMethod());
        if (!repTypesFromWadl.isEmpty()) {
            for (QName qName : repTypesFromWadl) {
                String nsUri = qName.getNamespaceURI();
                this.getBean().addOutputWrapperName(qName.getLocalPart());
                this.getBean().addOutputWrapperPackageName((this.getBean().getGroupName() + "." + this.getBean().getDisplayName()).toLowerCase() + "." + nsUri.substring(nsUri.lastIndexOf(":") + 1).toLowerCase());
            }
        }
    }

    @Deprecated
    protected void addJaxbLib() throws IOException {
    }

    protected String getCustomMethodBody() throws IOException {
        String paramUse = "";
        String paramDecl = "";
        List<ParameterInfo> params = this.getServiceMethodParameters();
        this.clearVariablePatterns();
        this.updateVariableNames(params);
        List renamedParams = this.renameParameterNames(params);
        paramUse = paramUse + Util.getHeaderOrParameterUsage((List)renamedParams);
        paramDecl = paramDecl + this.getHeaderOrParameterDeclaration(renamedParams);
        String methodBody = "\n        try {\n";
        methodBody = methodBody + paramDecl + "\n";
        methodBody = methodBody + "             RestResponse " + this.getResultPattern() + " = " + this.getBean().getSaasServiceName() + "." + this.getBean().getSaasServiceMethodName() + "(" + paramUse + ");\n";
        methodBody = methodBody + Util.createPrintStatement((List)this.getBean().getOutputWrapperPackageNames(), (List)this.getBean().getOutputWrapperNames(), (Constants.DropFileType)this.getDropFileType(), (Constants.HttpMethodType)this.getBean().getHttpMethod(), (boolean)this.getBean().canGenerateJAXBUnmarshaller(), (String)this.getResultPattern(), (String)"             ");
        methodBody = methodBody + "        } catch (Exception ex) {\n";
        methodBody = methodBody + "             ex.printStackTrace();\n";
        methodBody = methodBody + "        }\n";
        return methodBody;
    }

    protected String getServiceMethodBody() throws IOException {
        String methodBody = "";
        methodBody = methodBody + "        " + this.getFixedParameterDeclaration();
        methodBody = methodBody + "             " + this.getAuthenticationGenerator().getPreAuthenticationCode() + "\n";
        methodBody = methodBody + "        " + this.getTemplateParameterDefinition(this.getBean().getTemplateParameters(), "pathParams", false);
        methodBody = methodBody + "        " + Util.getHeaderOrParameterDefinition((List)this.getBean().getQueryParameters(), (String)"queryParams", (boolean)false);
        methodBody = methodBody + "             RestConnection conn = new RestConnection(\"" + this.getBean().getUrl() + "\"";
        methodBody = methodBody + ", pathParams";
        methodBody = methodBody + ", " + (!Util.isPutPostFormParams((RestClientSaasBean)this.getBean()) ? "queryParams" : "null");
        methodBody = methodBody + ");\n";
        methodBody = methodBody + "             " + this.getAuthenticationGenerator().getPostAuthenticationCode() + "\n";
        Constants.HttpMethodType httpMethod = this.getBean().getHttpMethod();
        String headerUsage = "null";
        if (this.getBean().getHeaderParameters() != null && this.getBean().getHeaderParameters().size() > 0) {
            headerUsage = "headerParams";
            methodBody = methodBody + "        " + Util.getHeaderOrParameterDefinition((List)this.getBean().getHeaderParameters(), (String)"headerParams", (boolean)false, (Constants.HttpMethodType)httpMethod);
        }
        methodBody = methodBody + "             sleep(1000);\n";
        methodBody = methodBody + "             return conn." + httpMethod.prefix() + "(" + headerUsage;
        if (httpMethod == Constants.HttpMethodType.PUT || httpMethod == Constants.HttpMethodType.POST) {
            if (Util.isPutPostFormParams((RestClientSaasBean)this.getBean())) {
                methodBody = methodBody + ", queryParams";
            } else if (Util.hasInputRepresentations((RestClientSaasBean)this.getBean())) {
                methodBody = methodBody + ", content";
            }
        }
        methodBody = methodBody + ");\n";
        return methodBody;
    }

    protected String getFixedParameterDeclaration() {
        String fixedCode = "";
        List signParams = null;
        Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            signParams = sessionKey.getParameters();
        } else {
            signParams = Collections.emptyList();
        }
        for (ParameterInfo param : this.getBean().getInputParameters()) {
            if (!param.isFixed() || Util.isContains((ParameterInfo)param, (List)signParams)) continue;
            fixedCode = fixedCode + "String " + this.getVariableName(param.getName()) + " = \"" + this.findParamValue(param) + "\";\n";
        }
        return fixedCode;
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        return Util.getRestClientMethodParameters((RestClientSaasBean)this.getBean());
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getSaasServiceName());
        imports.add("org.netbeans.saas.RestResponse");
        JavaUtil.addImportsToSource(this.getTargetSource(), imports);
    }

    protected void addImportsToSaasService() throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("org.netbeans.saas.RestConnection");
        imports.add("org.netbeans.saas.RestResponse");
        JavaUtil.addImportsToSource(this.saasServiceJS, imports);
    }

    protected void insertSaasServiceAccessCode(boolean isInBlock) throws IOException {
        try {
            String code = "";
            if (isInBlock) {
                code = this.getCustomMethodBody();
            } else {
                code = "\nprivate String call" + this.getBean().getName() + "Service() {\n";
                code = code + this.getCustomMethodBody() + "\n";
                code = code + "return " + this.getResultPattern() + ";\n";
                code = code + "}\n";
            }
            this.insert(code, true);
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void createSaasServiceClass() throws IOException {
        if (this.saasServiceFile == null) {
            SourceGroup[] srcGrps = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            String pkg = this.getBean().getSaasServicePackageName();
            FileObject targetFolder = SourceGroupSupport.getFolderForPackage(srcGrps[0], pkg, true);
            this.saasServiceJS = JavaSourceHelper.createJavaSource(this.getBean().getSaasServiceTemplate() + "." + "java", targetFolder, pkg, this.getBean().getSaasServiceName());
            HashSet files = new HashSet(this.saasServiceJS.getFileObjects());
            if (files != null && files.size() > 0) {
                this.saasServiceFile = (FileObject)files.iterator().next();
            }
        }
    }

    protected void addSaasServiceMethod() throws IOException {
        List<ParameterInfo> filterParams = this.getServiceMethodParameters();
        final String[] parameters = this.getGetParamNames(filterParams);
        final Object[] paramTypes = this.getGetParamTypes(filterParams);
        if (JavaSourceHelper.isContainsMethod(this.saasServiceJS, this.getBean().getSaasServiceMethodName(), parameters, paramTypes)) {
            return;
        }
        ModificationResult result = this.saasServiceJS.runModificationTask((Task)new AbstractTask<WorkingCopy>(this){
            final /* synthetic */ RestClientPojoCodeGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy copy) throws IOException {
                copy.toPhase(JavaSource.Phase.RESOLVED);
                Modifier[] modifiers = JavaUtil.PUBLIC_STATIC;
                String type = "RestResponse";
                String bodyText = "{ \n" + this.this$0.getServiceMethodBody() + "\n }";
                String comment = "\n";
                for (String param : parameters) {
                    comment = comment + "@param $PARAM$ \n".replace("$PARAM$", param);
                }
                comment = comment + "@return an instance of " + type;
                ClassTree initial = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                ClassTree tree = JavaSourceHelper.addMethod(copy, initial, modifiers, null, null, this.this$0.getBean().getSaasServiceMethodName(), type, parameters, paramTypes, null, null, new String[]{"java.io.IOException"}, bodyText, comment);
                copy.rewrite((Tree)initial, (Tree)tree);
            }
        });
        result.commit();
    }

    public ParameterInfo findParameter(String name) {
        List params = this.getBean().getInputParameters();
        if (params != null) {
            for (ParameterInfo param : params) {
                if (!param.getName().equals(name)) continue;
                return param;
            }
        }
        return null;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> params, String indent) {
        if (indent == null) {
            indent = " ";
        }
        String paramDecl = "";
        for (ParameterInfo param : params) {
            String name = this.getVariableName(param.getName());
            String paramVal = this.findParamValue(param);
            if (param.getType() != String.class) {
                paramDecl = paramDecl + indent + param.getType().getName() + " " + name + " = " + paramVal + ";\n";
                continue;
            }
            if (paramVal != null) {
                paramDecl = paramDecl + indent + "String " + name + " = \"" + paramVal + "\";\n";
                continue;
            }
            paramDecl = paramDecl + indent + "String " + name + " = null;\n";
        }
        return paramDecl;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> params) {
        String indent = "                 ";
        return this.getHeaderOrParameterDeclaration(params, indent);
    }

    private String getTemplateParameterDefinition(List<ParameterInfo> params, String varName, boolean evaluate) {
        String paramsStr = null;
        StringBuffer sb = new StringBuffer();
        for (ParameterInfo param : params) {
            String paramName = this.getParameterName(param);
            String paramVal = null;
            if (evaluate) {
                paramVal = this.findParamValue(param);
                if (param.getType() != String.class) {
                    sb.append("{\"" + paramName + "\", \"" + paramVal + "\".toString()},\n");
                    continue;
                }
                if (paramVal != null) {
                    sb.append("{\"{" + paramName + "}\", \"" + paramVal + "\"},\n");
                    continue;
                }
                sb.append("{\"{" + paramName + "}\", null},\n");
                continue;
            }
            sb.append("{\"{" + paramName + "}\", " + paramName + "},\n");
        }
        paramsStr = sb.toString();
        if (params.size() > 0) {
            paramsStr = paramsStr.substring(0, paramsStr.length() - 1);
        }
        String paramCode = "";
        paramCode = paramCode + "             String[][] " + varName + " = new String[][]{\n";
        paramCode = paramCode + "                 " + paramsStr + "\n";
        paramCode = paramCode + "             };\n";
        return paramCode;
    }

    private String findParamValue(ParameterInfo param) {
        return Util.findParamValue((ParameterInfo)param);
    }

    protected void createRestConnectionFile(Project project) throws IOException {
        SourceGroup[] srcGrps = SourceGroupSupport.getJavaSourceGroups(project);
        String pkg = "org.netbeans.saas";
        FileObject targetFolder = SourceGroupSupport.getFolderForPackage(srcGrps[0], pkg, true);
        JavaSourceHelper.createJavaSource("Templates/SaaSServices/RestConnection.java", targetFolder, pkg, "RestConnection");
        String restResponseTemplate = "Templates/SaaSServices/RestResponse.java";
        JavaSource restResponseJS = JavaSourceHelper.createJavaSource(restResponseTemplate, targetFolder, pkg, "RestResponse");
    }
}

