/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.team.commons.ColorManager;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.netbeans.modules.team.commons.treelist.TreeListNode;

final class RendererPanel
extends JPanel {
    private static final ColorManager colorManager = ColorManager.getDefault();
    private static final Border NO_FOCUS_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorManager.getDefault().getDefaultBackground()), BorderFactory.createEmptyBorder(1, 1, 0, 1));
    private static Border INNER_BORDER;
    private static Color expandableRootBackground;
    private static Color expandableRootForeground;
    private static Color expandableRootSelectedBackground;
    private static Color expandableRootSelectedForeground;
    private static final Icon EMPTY_ICON;
    private final boolean isRoot;
    private final TreeListNode node;
    private JButton expander;
    private int depth = 0;

    public RendererPanel(final TreeListNode node) {
        super(new BorderLayout());
        if (null == expandableRootBackground) {
            RendererPanel.deriveColorsAndMargin();
        }
        this.node = node;
        this.isRoot = node.getParent() == null;
        this.setOpaque(!this.isRoot || !colorManager.isAqua() || !node.isExpandable() || node.getType().equals((Object)TreeListNode.Type.TITLE));
        if (node.isExpandable()) {
            this.expander = new LinkButton(EMPTY_ICON, (Action)new AbstractAction(this){
                final /* synthetic */ RendererPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!node.isLoaded()) {
                        return;
                    }
                    node.setExpanded(!node.isExpanded());
                }
            });
            this.add((Component)this.expander, "West");
        } else if (!this.isRoot || node.getType().equals((Object)TreeListNode.Type.CLOSED)) {
            // empty if block
        }
        this.depth = this.getDepth();
    }

    private int getDepth() {
        int d = 1;
        TreeListNode parent = this.node;
        while (parent.getParent() != null) {
            parent = parent.getParent();
            ++d;
        }
        return d;
    }

    public void configure(Color foreground, Color background, boolean isSelected, boolean hasFocus, int nestingDepth, int rowHeight, int rowWidth) {
        if (this.isRoot && this.node.isExpandable() || this.node.getType().equals((Object)TreeListNode.Type.CLOSED)) {
            foreground = isSelected ? expandableRootSelectedForeground : expandableRootForeground;
            background = isSelected ? expandableRootSelectedBackground : expandableRootBackground;
        } else if (this.node.getType().equals((Object)TreeListNode.Type.TITLE)) {
            foreground = isSelected ? expandableRootSelectedForeground : colorManager.getDefaultBackground();
            background = isSelected ? colorManager.getTitleSelectedBackground() : colorManager.getTitleBackground();
        }
        int maxWidth = rowWidth - this.depth * EMPTY_ICON.getIconWidth() - (4 + nestingDepth * rowHeight / 2) - 4;
        if (this.expander == null) {
            maxWidth += EMPTY_ICON.getIconWidth();
        }
        JComponent inner = this.node.getComponent(foreground, background, isSelected, hasFocus, maxWidth > 0 ? maxWidth : 0);
        if (this.node.isExpandable() || !this.isRoot || this.node.getType().equals((Object)TreeListNode.Type.CLOSED)) {
            inner.setBorder(INNER_BORDER);
        }
        this.add((Component)inner, "Center");
        this.setBackground(background);
        this.setForeground(foreground);
        if (null != this.expander) {
            this.expander.setEnabled(this.node.isLoaded());
            this.expander.setIcon(this.node.isLoaded() ? (this.node.isExpanded() ? RendererPanel.getExpandedIcon() : RendererPanel.getCollapsedIcon()) : EMPTY_ICON);
            this.expander.setPressedIcon(this.expander.getIcon());
        }
        Border border = null;
        if (hasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        }
        if (null == border) {
            border = NO_FOCUS_BORDER;
        }
        border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(2, 4 + nestingDepth * rowHeight / 2, 2, 4));
        try {
            this.setBorder(border);
        }
        catch (NullPointerException npe) {
            Logger.getLogger(RendererPanel.class.getName()).log(Level.INFO, "Bug #175940", npe);
        }
        RendererPanel.configureAccessibility(this, true);
    }

    static void configureAccessibility(Component rendererComp, boolean combineAll) {
        StringBuilder accNameBuf = new StringBuilder();
        String accDesc = null;
        LinkedList<Component> comps = new LinkedList<Component>();
        comps.add(rendererComp);
        do {
            Component comp;
            if (!(comp = (Component)comps.remove(0)).isVisible()) continue;
            if (comp instanceof JPanel) {
                Component[] subComps = ((JPanel)comp).getComponents();
                for (int i = 0; i < subComps.length; ++i) {
                    comps.add(i, subComps[i]);
                }
            } else {
                String compAccDesc;
                String compAccName;
                if ((accNameBuf.length() == 0 || combineAll) && (compAccName = comp.getAccessibleContext().getAccessibleName()) != null && compAccName.length() > 0) {
                    if (accNameBuf.length() > 0 && !compAccName.startsWith(" ")) {
                        accNameBuf.append(" ");
                    }
                    accNameBuf.append(compAccName);
                }
                if (accDesc != null || (compAccDesc = comp.getAccessibleContext().getAccessibleDescription()) == null || compAccDesc.length() <= 0) continue;
                accDesc = compAccDesc;
            }
        } while (!comps.isEmpty() && (combineAll || accNameBuf.length() == 0 || accDesc == null));
        String accName = accNameBuf.toString();
        if (accName.length() > 0) {
            accName = accName.replace("<html>", "").replace("( ", "(").replace(" | ", ", ").replace(" )", ")").replace("...", "").replace("</html>", "");
            rendererComp.getAccessibleContext().setAccessibleName(accName);
        }
        if ((accDesc = accDesc != null ? accDesc.replace("<html>", "").replace("</html>", "") : accName).length() > 0) {
            rendererComp.getAccessibleContext().setAccessibleDescription(accDesc);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isRoot && colorManager.isAqua() && this.node.isExpandable() && this.node.isRenderedWithGradient()) {
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, this.getHeight() / 2, this.getBackground()));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setPaint(oldPaint);
        } else {
            super.paintComponent(g);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        JComponent jc;
        String tooltip;
        Component c = SwingUtilities.getDeepestComponentAt(this, event.getX(), event.getY());
        if (c instanceof JComponent && null != (tooltip = (jc = (JComponent)c).getToolTipText())) {
            return tooltip;
        }
        return super.getToolTipText(event);
    }

    private static void deriveColorsAndMargin() {
        expandableRootBackground = colorManager.getExpandableRootBackground();
        expandableRootForeground = colorManager.getExpandableRootForeground();
        expandableRootSelectedBackground = colorManager.getExpandableRootSelectedBackground();
        expandableRootSelectedForeground = colorManager.getExpandableRootSelectedForeground();
        Integer i = (Integer)UIManager.get("netbeans.ps.iconmargin");
        int iconMargin = 0;
        iconMargin = i != null ? i : (colorManager.isWindows() ? 4 : 0);
        INNER_BORDER = BorderFactory.createEmptyBorder(0, iconMargin, 0, 0);
    }

    static Icon getExpandedIcon() {
        Icon expandedIcon = UIManager.getIcon(colorManager.isGtk() ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon");
        assert (expandedIcon != null) : "no Tree.expandedIcon found";
        return expandedIcon;
    }

    static Icon getCollapsedIcon() {
        Icon collapsedIcon = UIManager.getIcon(colorManager.isGtk() ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon");
        assert (collapsedIcon != null) : "no Tree.collapsedIcon found";
        return collapsedIcon;
    }

    static {
        expandableRootBackground = null;
        expandableRootForeground = null;
        expandableRootSelectedBackground = null;
        expandableRootSelectedForeground = null;
        EMPTY_ICON = new EmptyIcon();
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return RendererPanel.getExpandedIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return RendererPanel.getExpandedIcon().getIconHeight();
        }
    }
}

