/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.editor.csl.CssAnalyser;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.openide.util.NbBundle;

public class CssHintsProvider
implements HintsProvider {
    private static final CssRule ERROR_RULE = new CssRule(HintSeverity.ERROR);
    private static final CssRule WARNING_RULE = new CssRule(HintSeverity.WARNING);

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        CssParserResult result = (CssParserResult)context.parserResult;
        HashSet<String> disableFixActionNames = new HashSet<String>();
        for (FilterableError e : result.getDiagnostics(true)) {
            if (e.isFiltered()) {
                FilterableError.SetFilterAction disableFilterAction = e.getDisableFilterAction();
                if (disableFixActionNames.contains(disableFilterAction.getDisplayName())) continue;
                disableFixActionNames.add(disableFilterAction.getDisplayName());
                hints.add(new Hint((Rule)new CssRule(HintSeverity.WARNING), disableFilterAction.getDisplayName(), context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(0, 0), Collections.singletonList(new ErrorCheckFix(disableFilterAction)), 10));
                continue;
            }
            Collection enableFilterActions = e.getEnableFilterActions();
            ArrayList<ErrorCheckFix> fixes = new ArrayList<ErrorCheckFix>();
            for (FilterableError.SetFilterAction action : enableFilterActions) {
                fixes.add(new ErrorCheckFix(action));
            }
            int astFrom = e.getStartPosition();
            int astTo = e.getEndPosition();
            int docFrom = context.parserResult.getSnapshot().getOriginalOffset(astFrom);
            int docTo = context.parserResult.getSnapshot().getOriginalOffset(astTo);
            if (docFrom == -1 || docTo == -1) continue;
            Hint h = new Hint((Rule)CssHintsProvider.getCssRule(e.getSeverity()), e.getDescription(), e.getFile(), new OffsetRange(docFrom, docTo), fixes, 10);
            hints.add(h);
        }
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static CssRule getCssRule(Severity s) {
        switch (s) {
            case WARNING: {
                return WARNING_RULE;
            }
            case ERROR: {
                return ERROR_RULE;
            }
        }
        throw new AssertionError((Object)"Unexpected severity level");
    }

    private static String getMessageKey(String errorKey, boolean enabled) {
        String param = null;
        String keyEnable = null;
        String keyDisable = null;
        if (CssAnalyser.isUnknownPropertyError(errorKey)) {
            keyEnable = "MSG_Disable_Ignore_Property";
            keyDisable = "MSG_Enable_Ignore_Property";
            param = CssAnalyser.getUnknownPropertyName(errorKey);
        } else {
            keyEnable = "MSG_Disable_Check";
            keyDisable = "MSG_Enable_Check";
        }
        return enabled ? NbBundle.getMessage(CssHintsProvider.class, (String)keyEnable, (Object)param) : NbBundle.getMessage(CssHintsProvider.class, (String)keyDisable, (Object)param);
    }

    private static final class CssRule
    implements Rule.ErrorRule {
        private final HintSeverity severity;

        private CssRule(HintSeverity severity) {
            this.severity = severity;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "css";
        }

        public boolean showInTasklist() {
            return true;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }

    private static final class ErrorCheckFix
    implements HintFix {
        private final FilterableError.SetFilterAction action;

        public ErrorCheckFix(FilterableError.SetFilterAction action) {
            this.action = action;
        }

        public String getDescription() {
            return this.action.getDisplayName();
        }

        public void implement() throws Exception {
            this.action.run();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

