/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.AddFriendPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicCustomizer;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class CustomizerVersioning
extends NbPropertyPanel.Single {
    private static final int CHECKBOX_WIDTH = new JCheckBox().getWidth();
    private boolean lastAppImplChecked;
    private Dimension lastSize;
    BasicCustomizer.SubCategoryProvider provider;
    private JButton addFriendButton;
    private JCheckBox appendImpl;
    private JRadioButton autoloadMod;
    private JPanel bottomPanel;
    private JPanel buttonPanel1;
    private JPanel buttonPanel3;
    private JLabel cnb;
    private JTextField cnbValue;
    private JButton deselectAllPkgsButton;
    private JRadioButton eagerMod;
    private JCheckBox exportOnlyToFriend;
    private JLabel filler1;
    private JLabel filler3;
    private JList friendsList;
    private JScrollPane friendsSP;
    private JLabel implVer;
    private JTextField implVerValue;
    private JLabel majorRelVer;
    private JTextField majorRelVerValue;
    private ButtonGroup moduleTypeGroup;
    private JPanel publicPackagesPanel;
    private JLabel publicPkgs;
    private JScrollPane publicPkgsSP;
    private JTable publicPkgsTable;
    private JRadioButton regularMod;
    private JButton removeFriendButton;
    private JButton selectAllPkgsButton;
    private JLabel specificationVer;
    private JTextField specificationVerValue;
    private JLabel tokens;
    private JTextField tokensValue;
    private JPanel typePanel;
    private JLabel typeTxt;

    CustomizerVersioning(SingleModuleProperties props, ProjectCustomizer.Category cat, BasicCustomizer.SubCategoryProvider prov) {
        super(props, CustomizerVersioning.class, cat);
        this.initComponents();
        this.initAccesibility();
        this.initPublicPackageTable();
        this.refresh();
        this.attachListeners();
        this.checkValidity();
        this.provider = prov;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.provider != null) {
            this.showSubCategory(this.provider);
            this.provider = null;
        }
    }

    @Override
    protected void refresh() {
        ApisupportAntUIUtils.setText(this.majorRelVerValue, this.getProperties().getMajorReleaseVersion());
        ApisupportAntUIUtils.setText(this.tokensValue, this.getProperties().getProvidedTokens());
        String specVersion = this.getProperties().getSpecificationVersion();
        if (this.getProperties().isOSGi()) {
            ApisupportAntUIUtils.setText(this.specificationVerValue, specVersion);
            this.appendImpl.setEnabled(false);
            this.implVer.setEnabled(false);
            this.implVerValue.setEnabled(false);
        } else {
            if (null == specVersion || "".equals(specVersion)) {
                this.appendImpl.setSelected(true);
                ApisupportAntUIUtils.setText(this.specificationVerValue, this.getProperty("spec.version.base"));
            } else {
                ApisupportAntUIUtils.setText(this.specificationVerValue, specVersion);
            }
            ApisupportAntUIUtils.setText(this.implVerValue, this.getProperties().getImplementationVersion());
        }
        this.friendsList.setModel(this.getProperties().getFriendListModel());
        ApisupportAntUIUtils.setText(this.cnbValue, this.getProperties().getCodeNameBase());
        this.regularMod.setSelected(true);
        this.autoloadMod.setSelected(this.getBooleanProperty("is.autoload"));
        this.eagerMod.setSelected(this.getBooleanProperty("is.eager"));
        this.removeFriendButton.setEnabled(false);
        this.getProperties().getDependenciesListModelInBg(new Runnable(){

            @Override
            public void run() {
                CustomizerVersioning.this.updateAppendImpl();
            }
        });
    }

    private void attachListeners() {
        this.friendsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CustomizerVersioning.this.removeFriendButton.setEnabled(CustomizerVersioning.this.friendsList.getSelectedIndex() != -1);
                }
            }
        });
        this.majorRelVerValue.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                CustomizerVersioning.this.checkValidity();
            }
        });
        this.implVerValue.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                CustomizerVersioning.this.updateAppendImpl();
                CustomizerVersioning.this.checkValidity();
            }
        });
        this.specificationVerValue.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                CustomizerVersioning.this.checkValidity();
            }
        });
        this.publicPkgsTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row = CustomizerVersioning.this.publicPkgsTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                Boolean b = (Boolean)CustomizerVersioning.this.publicPkgsTable.getValueAt(row, 0);
                if (!b.booleanValue() && !CustomizerVersioning.this.selectAllPkgsButton.isEnabled()) {
                    CustomizerVersioning.this.selectAllPkgsButton.setEnabled(true);
                }
                if (b.booleanValue() && !CustomizerVersioning.this.deselectAllPkgsButton.isEnabled()) {
                    CustomizerVersioning.this.deselectAllPkgsButton.setEnabled(true);
                }
                CustomizerVersioning.this.checkPublicPackagesSelectionButtons();
                CustomizerVersioning.this.checkValidity();
            }
        });
    }

    boolean isCustomizerValid() {
        return this.checkMajorReleaseVersion();
    }

    private boolean checkMajorReleaseVersion() {
        boolean valid;
        String mrv = this.majorRelVerValue.getText().trim();
        try {
            valid = mrv.length() == 0 || Integer.parseInt(mrv) >= 0;
        }
        catch (NumberFormatException nfe) {
            valid = false;
        }
        return valid;
    }

    protected void checkValidity() {
        this.exportOnlyToFriend.setSelected(this.getFriendModel().getSize() > 0);
        if (!this.checkMajorReleaseVersion()) {
            this.category.setErrorMessage(this.getMessage("MSG_MajorReleaseVersionIsInvalid"));
            this.category.setValid(false);
        } else if (this.exportOnlyToFriend.isSelected() && this.getPublicPackagesModel().getSelectedPackages().size() < 1) {
            this.category.setErrorMessage(this.getMessage("MSG_PublicPackageMustBeSelected"));
            this.category.setValid(false);
        } else if (this.implVerValue.getText().matches(".*[^0-9].*")) {
            this.category.setErrorMessage(this.getMessage("MSG_integer_impl_version_recommended"));
            this.category.setValid(true);
        } else {
            boolean ok = true;
            String text = this.specificationVerValue.getText();
            if (text != null && !text.isEmpty() && !text.matches("(0|[1-9][0-9]*)([.](0|[1-9][0-9]*))*")) {
                ok = false;
            }
            if (ok) {
                this.category.setErrorMessage(null);
                this.category.setValid(true);
            } else {
                this.category.setErrorMessage(this.getMessage("MSG_invalid_spec_version"));
                this.category.setValid(false);
            }
        }
    }

    private void initPublicPackageTable() {
        this.publicPkgsTable.setModel(this.getProperties().getPublicPackagesModel());
        this.publicPkgsTable.getColumnModel().getColumn(0).setMaxWidth(CHECKBOX_WIDTH + 20);
        this.publicPkgsTable.setRowHeight(this.publicPkgsTable.getFontMetrics(this.publicPkgsTable.getFont()).getHeight() + 2 * this.publicPkgsTable.getRowMargin());
        this.publicPkgsTable.setTableHeader(null);
        this.publicPkgsTable.getSelectionModel().setSelectionMode(0);
        this.publicPkgsSP.getViewport().setBackground(this.publicPkgsTable.getBackground());
        final AbstractAction switchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = CustomizerVersioning.this.publicPkgsTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                Boolean b = (Boolean)CustomizerVersioning.this.publicPkgsTable.getValueAt(row, 0);
                CustomizerVersioning.this.publicPkgsTable.setValueAt(b == false, row, 0);
                CustomizerVersioning.this.checkValidity();
            }
        };
        this.publicPkgsTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ CustomizerVersioning this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                switchAction.actionPerformed(null);
            }
        });
        this.publicPkgsTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        this.publicPkgsTable.getActionMap().put("startEditing", switchAction);
        this.checkPublicPackagesSelectionButtons();
    }

    private void updateAppendImpl() {
        boolean shouldEnable;
        boolean isImplVerFiled = !"".equals(this.implVerValue.getText().trim());
        boolean bl = shouldEnable = isImplVerFiled || this.getProperties().dependingOnImplDependency();
        if (shouldEnable && !this.appendImpl.isEnabled()) {
            this.appendImpl.setEnabled(true);
            this.appendImpl.setSelected(this.lastAppImplChecked);
        } else if (!shouldEnable && this.appendImpl.isEnabled()) {
            this.appendImpl.setEnabled(false);
            this.lastAppImplChecked = this.appendImpl.isSelected();
            this.appendImpl.setSelected(false);
        }
    }

    @Override
    public void store() {
        this.getProperties().setMajorReleaseVersion(this.majorRelVerValue.getText().trim());
        String specVer = this.specificationVerValue.getText().trim();
        if (this.appendImpl.isSelected()) {
            this.getProperties().setSpecificationVersion("");
            this.setProperty("spec.version.base", specVer);
        } else {
            this.getProperties().setSpecificationVersion(specVer);
            this.setProperty("spec.version.base", "");
        }
        this.getProperties().setImplementationVersion(this.implVerValue.getText().trim());
        this.getProperties().setProvidedTokens(this.tokensValue.getText().trim());
        this.setBooleanProperty("is.autoload", this.autoloadMod.isSelected());
        this.setBooleanProperty("is.eager", this.eagerMod.isSelected());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pName = evt.getPropertyName();
        if ("moduleDependencies" == pName) {
            this.updateAppendImpl();
        } else if ("propertiesRefreshed" == pName) {
            this.refresh();
            this.checkValidity();
        }
    }

    private CustomizerComponentFactory.FriendListModel getFriendModel() {
        return (CustomizerComponentFactory.FriendListModel)this.friendsList.getModel();
    }

    private CustomizerComponentFactory.PublicPackagesTableModel getPublicPackagesModel() {
        return (CustomizerComponentFactory.PublicPackagesTableModel)this.publicPkgsTable.getModel();
    }

    private void initComponents() {
        this.moduleTypeGroup = new ButtonGroup();
        this.cnb = new JLabel();
        this.cnbValue = new JTextField();
        this.majorRelVer = new JLabel();
        this.majorRelVerValue = new JTextField();
        this.specificationVer = new JLabel();
        this.specificationVerValue = new JTextField();
        this.implVer = new JLabel();
        this.implVerValue = new JTextField();
        this.tokens = new JLabel();
        this.tokensValue = new JTextField();
        this.appendImpl = new JCheckBox();
        this.publicPkgs = new JLabel();
        this.bottomPanel = new JPanel();
        this.buttonPanel1 = new JPanel();
        this.addFriendButton = new JButton();
        this.removeFriendButton = new JButton();
        this.filler1 = new JLabel();
        this.friendsSP = new JScrollPane();
        this.friendsList = new JList();
        this.exportOnlyToFriend = new JCheckBox();
        this.typePanel = new JPanel();
        this.regularMod = new JRadioButton();
        this.autoloadMod = new JRadioButton();
        this.eagerMod = new JRadioButton();
        this.typeTxt = new JLabel();
        this.publicPackagesPanel = new JPanel();
        this.publicPkgsSP = new JScrollPane();
        this.publicPkgsTable = new JTable();
        Dimension tableDim = this.publicPkgsTable.getPreferredScrollableViewportSize();
        this.publicPkgsTable.setPreferredScrollableViewportSize(new Dimension(tableDim.width, 100));
        this.buttonPanel3 = new JPanel();
        this.selectAllPkgsButton = new JButton();
        this.deselectAllPkgsButton = new JButton();
        this.filler3 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.cnb.setLabelFor(this.cnbValue);
        Mnemonics.setLocalizedText((JLabel)this.cnb, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_CNB"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.cnb, gridBagConstraints);
        this.cnbValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cnbValue, gridBagConstraints);
        this.majorRelVer.setLabelFor(this.majorRelVerValue);
        Mnemonics.setLocalizedText((JLabel)this.majorRelVer, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_MajorReleaseVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.majorRelVer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.majorRelVerValue, gridBagConstraints);
        this.specificationVer.setLabelFor(this.specificationVerValue);
        Mnemonics.setLocalizedText((JLabel)this.specificationVer, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_SpecificationVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 12);
        this.add((Component)this.specificationVer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.specificationVerValue, gridBagConstraints);
        this.implVer.setLabelFor(this.implVerValue);
        Mnemonics.setLocalizedText((JLabel)this.implVer, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_ImplementationVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.implVer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.implVerValue, gridBagConstraints);
        this.tokens.setLabelFor(this.tokensValue);
        Mnemonics.setLocalizedText((JLabel)this.tokens, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_ProvidedTokens"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.tokens, gridBagConstraints);
        this.tokensValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerVersioning.this.tokensValueActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.tokensValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.appendImpl, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_AppendImplementation"));
        this.appendImpl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.appendImpl, gridBagConstraints);
        this.publicPkgs.setLabelFor(this.publicPkgsTable);
        Mnemonics.setLocalizedText((JLabel)this.publicPkgs, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_PublicPackages"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 2, 12);
        this.add((Component)this.publicPkgs, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.buttonPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addFriendButton, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_AddButton"));
        this.addFriendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerVersioning.this.addFriend(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel1.add((Component)this.addFriendButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeFriendButton, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_RemoveButton"));
        this.removeFriendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerVersioning.this.removeFriend(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.buttonPanel1.add((Component)this.removeFriendButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel1.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.bottomPanel.add((Component)this.buttonPanel1, gridBagConstraints);
        this.friendsList.setVisibleRowCount(3);
        this.friendsSP.setViewportView(this.friendsList);
        this.friendsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerVersioning.class, (String)"ACS_FriendsList"));
        this.friendsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerVersioning.class, (String)"ACSD_FriendsList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.bottomPanel.add((Component)this.friendsSP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.bottomPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.exportOnlyToFriend, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_ExportOnlyToFriends"));
        this.exportOnlyToFriend.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.exportOnlyToFriend.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.exportOnlyToFriend, gridBagConstraints);
        this.typePanel.setLayout(new GridBagLayout());
        this.moduleTypeGroup.add(this.regularMod);
        this.regularMod.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.regularMod, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_RegularModule"));
        this.regularMod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.typePanel.add((Component)this.regularMod, gridBagConstraints);
        this.moduleTypeGroup.add(this.autoloadMod);
        Mnemonics.setLocalizedText((AbstractButton)this.autoloadMod, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_AutoloadModule"));
        this.autoloadMod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.typePanel.add((Component)this.autoloadMod, gridBagConstraints);
        this.moduleTypeGroup.add(this.eagerMod);
        Mnemonics.setLocalizedText((AbstractButton)this.eagerMod, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_EagerModule"));
        this.eagerMod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.typePanel.add((Component)this.eagerMod, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.typeTxt, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_ModuleType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.typePanel.add((Component)this.typeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.typePanel, gridBagConstraints);
        this.publicPackagesPanel.setMinimumSize(new Dimension(112, 62));
        this.publicPackagesPanel.setPreferredSize(new Dimension(347, 62));
        this.publicPackagesPanel.setLayout(new GridBagLayout());
        this.publicPkgsTable.setShowHorizontalLines(false);
        this.publicPkgsSP.setViewportView(this.publicPkgsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.publicPackagesPanel.add((Component)this.publicPkgsSP, gridBagConstraints);
        this.buttonPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.selectAllPkgsButton, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_SelectAll"));
        this.selectAllPkgsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerVersioning.this.selectAllPkgsButtonaddFriend(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel3.add((Component)this.selectAllPkgsButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.deselectAllPkgsButton, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_DeselectAll"));
        this.deselectAllPkgsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerVersioning.this.deselectAllPkgsButtonremoveFriend(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.buttonPanel3.add((Component)this.deselectAllPkgsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel3.add((Component)this.filler3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.publicPackagesPanel.add((Component)this.buttonPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.8;
        this.add((Component)this.publicPackagesPanel, gridBagConstraints);
    }

    private void removeFriend(ActionEvent evt) {
        this.getFriendModel().removeFriend((String)this.friendsList.getSelectedValue());
        if (this.getFriendModel().getSize() > 0) {
            this.friendsList.setSelectedIndex(0);
        }
        this.friendsList.requestFocus();
        this.checkValidity();
    }

    private void addFriend(ActionEvent evt) {
        AddFriendPanel addFriend = new AddFriendPanel(this.getProperties());
        DialogDescriptor descriptor = new DialogDescriptor((Object)addFriend, this.getMessage("CTL_AddNewFriend_Title"));
        descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.apisupport.project.ui.customizer.AddFriendPanel"));
        final JButton okButton = new JButton(this.getMessage("CTL_OK"));
        JButton cancel = new JButton(this.getMessage("CTL_Cancel"));
        okButton.setEnabled(false);
        Object[] options = new Object[]{okButton, cancel};
        descriptor.setOptions(options);
        descriptor.setClosingOptions(options);
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        addFriend.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ CustomizerVersioning this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName() == "isPanelValid") {
                    okButton.setEnabled((Boolean)pce.getNewValue());
                }
            }
        });
        d.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_AddNewFriend_Title"));
        okButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_OK"));
        cancel.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_Cancel"));
        if (this.lastSize != null) {
            d.setSize(this.lastSize);
        } else {
            d.pack();
        }
        d.setLocationRelativeTo(null);
        d.setVisible(true);
        this.lastSize = d.getSize();
        if (descriptor.getValue().equals(okButton)) {
            String newFriendCNB = addFriend.getFriendCNB();
            this.getFriendModel().addFriend(newFriendCNB);
            this.friendsList.setSelectedValue(newFriendCNB, true);
            this.checkValidity();
        }
        d.dispose();
        this.friendsList.requestFocus();
    }

    private void tokensValueActionPerformed(ActionEvent evt) {
    }

    private void selectAllPkgsButtonaddFriend(ActionEvent evt) {
        this.selectOrDeselectAllPackages(true);
    }

    private void deselectAllPkgsButtonremoveFriend(ActionEvent evt) {
        this.selectOrDeselectAllPackages(false);
    }

    private String getMessage(String key) {
        return NbBundle.getMessage(CustomizerVersioning.class, (String)key);
    }

    public void showSubCategory(BasicCustomizer.SubCategoryProvider prov) {
        if ("Versioning".equals(prov.getCategory()) && "publicPackages".equals(prov.getSubcategory())) {
            this.publicPkgsTable.requestFocus();
        }
    }

    private void selectOrDeselectAllPackages(boolean check) {
        int rowCount = this.publicPkgsTable.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                this.publicPkgsTable.setValueAt(check, i, 0);
            }
        }
        this.selectAllPkgsButton.setEnabled(!check);
        this.deselectAllPkgsButton.setEnabled(check);
        this.checkValidity();
    }

    private void checkPublicPackagesSelectionButtons() {
        boolean enableSelectAllPkgsButton = false;
        boolean enableDeselectAllPkgsButton = false;
        int rowCount = this.publicPkgsTable.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                if (!((Boolean)this.publicPkgsTable.getValueAt(i, 0)).booleanValue()) {
                    enableSelectAllPkgsButton = true;
                    continue;
                }
                if (!((Boolean)this.publicPkgsTable.getValueAt(i, 0)).booleanValue()) continue;
                enableDeselectAllPkgsButton = true;
            }
        }
        this.selectAllPkgsButton.setEnabled(enableSelectAllPkgsButton);
        this.deselectAllPkgsButton.setEnabled(enableDeselectAllPkgsButton);
    }

    private void initAccesibility() {
        this.addFriendButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AddFriendButton"));
        this.removeFriendButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveFriendButton"));
        this.cnbValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CnbValue"));
        this.majorRelVerValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_MajorRelVerValue"));
        this.specificationVerValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_SpecificationVerValuea"));
        this.appendImpl.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AppendImpl"));
        this.implVerValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_ImplVerValue"));
        this.regularMod.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RegularMod"));
        this.autoloadMod.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AutoloadMod"));
        this.eagerMod.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_EagerMod"));
        this.publicPkgsTable.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_PublicPkgsTable"));
        this.tokensValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_TokensValue"));
    }
}

