/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;

public final class SuiteUtils {
    private static final String ANT_PURE_PROPERTY_REFERENCE_REGEXP = "\\$\\{\\p{Graph}+\\}";
    private static final String PRIVATE_PLATFORM_PROPERTIES = "nbproject/private/platform-private.properties";
    static final String MODULES_PROPERTY = "modules";
    @NonNull
    private final SuiteProperties suiteProps;
    private static final ThreadLocal<Boolean> temporaryChange = new ThreadLocal();

    private SuiteUtils(SuiteProperties suiteProps) {
        assert (suiteProps != null);
        this.suiteProps = suiteProps;
    }

    public static NbModuleProject[] getDependentModules(final NbModuleProject suiteComponent) throws IOException {
        final String cnb = suiteComponent.getCodeNameBase();
        try {
            return (NbModuleProject[])ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<NbModuleProject[]>(){

                public NbModuleProject[] run() throws Exception {
                    HashSet<NbModuleProject> result = new HashSet<NbModuleProject>();
                    SuiteProject suite = SuiteUtils.findSuite(suiteComponent);
                    if (suite == null) {
                        Util.err.log(16, "Cannot find suite for the given suitecomponent (" + String.valueOf(suiteComponent) + ")");
                    } else {
                        block0: for (NbModuleProject p : SuiteUtils.getSubProjects(suite)) {
                            for (ModuleDependency dep : new ProjectXMLManager(p).getDirectDependencies()) {
                                if (!dep.getModuleEntry().getCodeNameBase().equals(cnb)) continue;
                                result.add(p);
                                continue block0;
                            }
                        }
                    }
                    return result.toArray(new NbModuleProject[0]);
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void replaceSubModules(final SuiteProperties suiteProps) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    SuiteUtils utils = new SuiteUtils(suiteProps);
                    Set<NbModuleProject> currentModules = suiteProps.getSubModules();
                    Set<NbModuleProject> origSubModules = suiteProps.getOrigSubModules();
                    for (NbModuleProject origModule : origSubModules) {
                        if (currentModules.contains(origModule)) continue;
                        Util.err.log("Removing module: " + String.valueOf(origModule));
                        SuiteUtils.removeModule(origModule, suiteProps);
                    }
                    for (NbModuleProject currentModule : currentModules) {
                        if (SuiteUtils.contains(suiteProps.getProject(), currentModule)) {
                            Util.err.log("Module \"" + String.valueOf(currentModule) + "\" or a module with the same CNB is already contained in the suite.");
                            continue;
                        }
                        utils.addModule(currentModule);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void addModule(final SuiteProject suite, final NbModuleProject project) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    SuiteProperties suiteProps = new SuiteProperties(suite, suite.getHelper(), suite.getEvaluator(), SuiteUtils.getSubProjects(suite));
                    if (!SuiteUtils.contains(suite, project)) {
                        SuiteUtils utils = new SuiteUtils(suiteProps);
                        utils.addModule(project);
                        suiteProps.storeProperties();
                    } else {
                        Util.err.log("Module \"" + String.valueOf(project) + "\" or a module with the same CNB is already contained in the suite.");
                    }
                    ProjectManager.getDefault().saveProject((Project)suite);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void removeModuleFromSuiteWithDependencies(final NbModuleProject suiteComponent) throws IOException {
        suiteComponent.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                suiteComponent.setRunInAtomicAction(true);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){
                        final /* synthetic */ 4 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public Void run() throws Exception {
                            try {
                                NbModuleProject[] modules = SuiteUtils.getDependentModules(suiteComponent);
                                String cnb = suiteComponent.getCodeNameBase();
                                for (int j = 0; j < modules.length; ++j) {
                                    ProjectXMLManager pxm = new ProjectXMLManager(modules[j]);
                                    pxm.removeDependency(cnb);
                                    ProjectManager.getDefault().saveProject((Project)modules[j]);
                                }
                            }
                            catch (IOException x) {
                                Logger.getLogger(SuiteUtils.class.getName()).log(Level.INFO, null, x);
                            }
                            SuiteUtils.removeModuleFromSuite(suiteComponent);
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    throw (IOException)e.getException();
                }
                finally {
                    suiteComponent.setRunInAtomicAction(false);
                }
            }
        });
    }

    public static void removeModuleFromSuite(final NbModuleProject suiteComponent) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    SuiteProject suite = SuiteUtils.findSuite(suiteComponent);
                    if (suite != null) {
                        SuiteProperties suiteProps = new SuiteProperties(suite, suite.getHelper(), suite.getEvaluator(), SuiteUtils.getSubProjects(suite));
                        SuiteUtils.removeModule(suiteComponent, suiteProps);
                        suiteProps.storeProperties();
                        ProjectManager.getDefault().saveProject((Project)suite);
                    } else {
                        SuiteUtils.removeModule(suiteComponent, null);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private void addModule(NbModuleProject project) throws IOException, IllegalArgumentException {
        SuiteUtils.removeModuleFromSuite(project);
        this.attachSubModuleToSuite(project);
    }

    private static void removeModule(final NbModuleProject subModule, final SuiteProperties suiteProps) {
        try {
            if (!Boolean.TRUE.equals(temporaryChange.get())) {
                subModule.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        try {
                            EditableProperties props;
                            subModule.setRunInAtomicAction(true);
                            FileObject subModuleDir = subModule.getProjectDirectory();
                            FileObject fo = subModuleDir.getFileObject("nbproject/suite.properties");
                            if (fo != null) {
                                fo.delete();
                            }
                            if ((fo = subModuleDir.getFileObject("nbproject/private/suite-private.properties")) != null) {
                                fo.delete();
                            }
                            if (suiteProps != null) {
                                FileObject plafPropsFO = suiteProps.getProject().getProjectDirectory().getFileObject("nbproject/platform.properties");
                                FileObject subModuleNbProject = subModuleDir.getFileObject("nbproject");
                                if (subModuleNbProject != null && subModuleNbProject.getFileObject("platform.properties") == null) {
                                    FileUtil.copyFile((FileObject)plafPropsFO, (FileObject)subModuleNbProject, (String)"platform");
                                }
                            }
                            if ((props = subModule.getHelper().getProperties(SuiteUtils.PRIVATE_PLATFORM_PROPERTIES)).getProperty("user.properties.file") == null) {
                                String nbuser = System.getProperty("netbeans.user");
                                if (nbuser != null) {
                                    props.setProperty("user.properties.file", new File(nbuser, "build.properties").getAbsolutePath());
                                    subModule.getHelper().putProperties(SuiteUtils.PRIVATE_PLATFORM_PROPERTIES, props);
                                } else {
                                    Util.err.log("netbeans.user system property is not defined. Skipping nbproject/private/platform-private.properties creation.");
                                }
                            }
                            SuiteUtils.setNbModuleType(subModule, NbModuleType.STANDALONE);
                            ProjectManager.getDefault().saveProject((Project)subModule);
                        }
                        finally {
                            subModule.setRunInAtomicAction(false);
                        }
                    }
                });
            }
            if (suiteProps != null) {
                SuiteUtils.removeFromProperties(subModule, suiteProps);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static boolean removeFromProperties(NbModuleProject moduleToRemove, SuiteProperties suiteProps) {
        String modulesProp = suiteProps.getProperty(MODULES_PROPERTY);
        boolean removed = false;
        if (modulesProp != null) {
            ArrayList<String> pieces = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)modulesProp)));
            Iterator piecesIt = pieces.iterator();
            while (piecesIt.hasNext()) {
                String unevaluated = (String)piecesIt.next();
                String evaluated = suiteProps.getEvaluator().evaluate(unevaluated);
                if (evaluated == null) {
                    Util.err.log("Cannot evaluate " + unevaluated + " property.");
                    continue;
                }
                if (moduleToRemove.getProjectDirectory() != suiteProps.getHelper().resolveFileObject(evaluated)) continue;
                piecesIt.remove();
                String[] newModulesProp = SuiteUtils.getAntProperty(pieces);
                suiteProps.getModulesListModel().removeModules(Collections.singletonList(moduleToRemove));
                suiteProps.setProperty(MODULES_PROPERTY, newModulesProp);
                removed = true;
                if (!unevaluated.matches(ANT_PURE_PROPERTY_REFERENCE_REGEXP)) break;
                String key = unevaluated.substring(2, unevaluated.length() - 1);
                suiteProps.removeProperty(key);
                suiteProps.removePrivateProperty(key);
                break;
            }
        }
        if (!removed) {
            Util.err.log("Removing of " + String.valueOf(moduleToRemove) + " was unsuccessful.");
        }
        return removed;
    }

    private void attachSubModuleToSuite(NbModuleProject subModule) throws IOException {
        File projectDirF = FileUtil.toFile((FileObject)subModule.getProjectDirectory());
        File suiteDirF = this.suiteProps.getProjectDirectoryFile();
        String projectPropKey = this.generatePropertyKey(subModule);
        String rel = PropertyUtils.relativizeFile((File)suiteDirF, (File)projectDirF);
        if (rel != null) {
            this.suiteProps.setProperty(projectPropKey, rel);
        } else {
            this.suiteProps.setPrivateProperty(projectPropKey, projectDirF.getAbsolutePath());
        }
        String origModules = this.suiteProps.getProperty(MODULES_PROPERTY);
        StringBuilder modules = new StringBuilder(origModules == null ? "" : origModules);
        if (modules.length() > 0) {
            modules.append(':');
        }
        modules.append("${").append(projectPropKey).append('}');
        this.suiteProps.setProperty(MODULES_PROPERTY, modules.toString().split("(?<=:)", -1));
        NbModuleProjectGenerator.createSuiteProperties(subModule.getProjectDirectory(), suiteDirF);
        SuiteUtils.setNbModuleType(subModule, NbModuleType.SUITE_COMPONENT);
        ProjectManager.getDefault().saveProject((Project)subModule);
    }

    private String generatePropertyKey(Project subModule) {
        String key = "project." + ProjectUtils.getInformation((Project)subModule).getName();
        String modules = this.suiteProps.getProperty(MODULES_PROPERTY);
        Object[] keys = modules != null ? modules.split("(?<=:)", -1) : new String[]{};
        int index = 0;
        while (Arrays.binarySearch(keys, "${" + key + "}") >= 0) {
            key = key + "_" + ++index;
        }
        return key;
    }

    private static void setNbModuleType(NbModuleProject module, NbModuleType type) throws IOException {
        ProjectXMLManager pxm = new ProjectXMLManager(module);
        pxm.setModuleType(type);
        module.refreshLookup();
    }

    public static String[] getAntProperty(Collection<String> pieces) {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        Iterator<String> it = pieces.iterator();
        while (it.hasNext()) {
            String piece = it.next() + (it.hasNext() ? ":" : "");
            l.add((CallSite)((Object)piece));
        }
        return l.toArray(new String[0]);
    }

    public static boolean isSuite(File maybeSuiteDir) {
        boolean isSuite = false;
        try {
            Project maybeSuite;
            FileObject dirFO = FileUtil.toFileObject((File)maybeSuiteDir);
            if (dirFO != null && (maybeSuite = ProjectManager.getDefault().findProject(dirFO)) != null) {
                isSuite = maybeSuiteDir.equals(SuiteUtils.getSuiteDirectory(maybeSuite));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isSuite;
    }

    public static SuiteProject findSuite(final Project suiteComponent) throws IOException {
        try {
            return (SuiteProject)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<SuiteProject>(){

                public SuiteProject run() throws Exception {
                    Project suite = null;
                    File suiteDir = SuiteUtils.getSuiteDirectory(suiteComponent);
                    if (suiteDir != null) {
                        FileObject fo = FileUtil.toFileObject((File)suiteDir);
                        if (fo == null) {
                            Util.err.log(16, "Module in the \"" + FileUtil.toFile((FileObject)suiteComponent.getProjectDirectory()).getAbsolutePath() + "\" directory claims to be a subcomponent of a suite in the \"" + suiteDir.getAbsolutePath() + "\" which does not exist however.");
                        } else {
                            suite = ProjectManager.getDefault().findProject(fo);
                        }
                    }
                    return suite instanceof SuiteProject ? (SuiteProject)suite : null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static boolean contains(SuiteProject suite, NbModuleProject project) {
        Set<NbModuleProject> subModules = SuiteUtils.getSubProjects(suite);
        if (subModules.contains(project)) {
            return true;
        }
        for (NbModuleProject p : subModules) {
            if (!p.getCodeNameBase().equals(project.getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    public static Set<NbModuleProject> getSubProjects(Project suite) {
        assert (suite != null);
        SubprojectProvider spp = (SubprojectProvider)suite.getLookup().lookup(SubprojectProvider.class);
        return NbCollections.checkedSetByFilter((Set)spp.getSubprojects(), NbModuleProject.class, (boolean)true);
    }

    public static File getSuiteDirectory(Project project) {
        File suiteDir = null;
        SuiteProvider sp = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        if (sp != null) {
            suiteDir = sp.getSuiteDirectory();
        }
        return suiteDir;
    }

    public static String getSuiteDirectoryPath(Project project) {
        File suiteDir = SuiteUtils.getSuiteDirectory(project);
        return suiteDir != null ? suiteDir.getAbsolutePath() : null;
    }

    public static <T> T moving(Callable<T> callable) throws IOException {
        Boolean temp = temporaryChange.get();
        try {
            temporaryChange.set(true);
            T t = callable.call();
            return t;
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
        finally {
            temporaryChange.set(temp);
        }
    }
}

