/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.toml.semantic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.vieiro.toml.antlr4.TOMLAntlrParser;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.languages.toml.TomlParser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public final class TomlSemanticAnalyzer
extends SemanticAnalyzer<TomlParser.TomlParserResult> {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    Map<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.highlights;
    }

    public void run(TomlParser.TomlParserResult result, SchedulerEvent event) {
        if (this.cancelled.get()) {
            return;
        }
        TOMLAntlrParser.DocumentContext document = result.getDocument();
        if (document == null) {
            return;
        }
        this.highlights.clear();
        for (TOMLAntlrParser.ExpressionContext expression : document.expression()) {
            TOMLAntlrParser.KeyContext key;
            TOMLAntlrParser.Standard_tableContext standardTable;
            TOMLAntlrParser.KeyContext key2;
            if (this.cancelled.get()) break;
            TOMLAntlrParser.TableContext tableContext = expression.table();
            if (tableContext == null) continue;
            TOMLAntlrParser.Array_tableContext arrayTable = tableContext.array_table();
            if (arrayTable != null && (key2 = arrayTable.key()) != null) {
                this.addHilightForKey(key2);
            }
            if ((standardTable = tableContext.standard_table()) == null || (key = standardTable.key()) == null) continue;
            this.addHilightForKey(key);
        }
    }

    private void addHilightForKey(TOMLAntlrParser.KeyContext key) {
        int startIndex = key.start.getStartIndex();
        int stopIndex = key.stop.getStopIndex() + 1;
        OffsetRange range = new OffsetRange(startIndex, stopIndex);
        HashSet keyColoring = new HashSet();
        this.highlights.put(range, ColoringAttributes.GLOBAL_SET);
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled.set(true);
    }
}

