/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.Set;

@GenerateUncached
public abstract class JSToNumberNode
extends JavaScriptBaseNode {
    public abstract Object execute(Object var1);

    public final Number executeNumber(Object value) {
        return (Number)this.execute(value);
    }

    @NeverDefault
    public static JSToNumberNode create() {
        return JSToNumberNodeGen.create();
    }

    public static JavaScriptNode create(JavaScriptNode child) {
        if (child.isResultAlwaysOfType(Number.class) || child.isResultAlwaysOfType(Integer.TYPE) || child.isResultAlwaysOfType(Double.TYPE)) {
            return child;
        }
        return JSToNumberNodeGen.JSToNumberUnaryNodeGen.create(child);
    }

    @Specialization
    protected static int doInteger(int value) {
        return value;
    }

    @Specialization
    protected static int doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization
    protected static double doDouble(double value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static int doNull(Object value) {
        return 0;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static double doUndefined(Object value) {
        return Double.NaN;
    }

    @Specialization
    protected Number doString(TruffleString value, @Cached JSStringToNumberNode stringToNumberNode) {
        double doubleValue = stringToNumberNode.execute(value);
        return JSRuntime.doubleToNarrowestNumber(doubleValue);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected Number doJSObject(JSObject value, @Cached.Shared @Cached(value="createHintNumber()", uncached="getUncachedHintNumber()") JSToPrimitiveNode toPrimitiveNode, @Cached.Shared @Cached JSToNumberNode toNumberNode) {
        return toNumberNode.executeNumber(toPrimitiveNode.execute((Object)value));
    }

    @Specialization
    protected final Number doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization(guards={"!value.isForeign()"})
    protected final Number doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value", this);
    }

    @Specialization(guards={"value.isForeign()"})
    protected static Number doForeignBigInt(BigInt value) {
        return value.doubleValue();
    }

    @Specialization
    protected static double doLong(long value) {
        return value;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isJSObject(value) || isForeignObject(value)"}, replaces={"doJSObject"})
    protected Number doJSOrForeignObject(Object value, @Cached.Shared @Cached(value="createHintNumber()", uncached="getUncachedHintNumber()") JSToPrimitiveNode toPrimitiveNode, @Cached.Shared @Cached JSToNumberNode toNumberNode) {
        return toNumberNode.executeNumber(toPrimitiveNode.execute(value));
    }

    public static abstract class JSToNumberUnaryNode
    extends JSUnaryNode {
        protected JSToNumberUnaryNode(JavaScriptNode operand) {
            super(operand);
        }

        @Specialization
        protected static Object doDefault(Object value, @Cached JSToNumberNode toNumberNode) {
            return toNumberNode.executeNumber(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToNumberNode.create(JSToNumberUnaryNode.cloneUninitialized(this.getOperand(), materializedTags));
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return super.isResultAlwaysOfType(Number.class);
        }

        @Override
        public String expressionToString() {
            return this.getOperand().expressionToString();
        }
    }
}

