/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class CustomizerSupport {
    private static final String CLASSPATH = "classpath";
    private static final String SOURCES = "src";
    private static final String JAVADOC = "javadoc";

    private CustomizerSupport() {
    }

    public static Component createClassesCustomizer(PathModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        return new PathView(model, CLASSPATH, null);
    }

    public static Component createSourcesCustomizer(PathModel model, File currentDir) {
        if (model == null) {
            throw new NullPointerException();
        }
        return new PathView(model, SOURCES, currentDir);
    }

    public static Component createJavadocCustomizer(PathModel model, File currentDir) {
        if (model == null) {
            throw new NullPointerException();
        }
        return new PathView(model, JAVADOC, currentDir);
    }

    public static String buildPath(List<URL> path) {
        String PATH_SEPARATOR = System.getProperty("path.separator");
        StringBuilder sb = new StringBuilder(path.size() * 16);
        Iterator<URL> i = path.iterator();
        while (i.hasNext()) {
            sb.append(CustomizerSupport.urlToString(i.next()));
            if (!i.hasNext()) continue;
            sb.append(PATH_SEPARATOR);
        }
        return sb.toString();
    }

    public static List<URL> tokenizePath(String path) {
        URL u;
        ArrayList<URL> l = new ArrayList<URL>();
        StringTokenizer tok = new StringTokenizer(path, ":;", true);
        char dosHack = '\u0000';
        int lastDelim = 0;
        int delimCount = 0;
        while (tok.hasMoreTokens()) {
            char c;
            String s = tok.nextToken();
            if (s.length() == 0) continue;
            if (s.length() == 1 && ((c = s.charAt(0)) == ':' || c == ';')) {
                lastDelim = c;
                ++delimCount;
                continue;
            }
            if (dosHack != '\u0000') {
                if (lastDelim == 58 && delimCount == 1 && (s.charAt(0) == '\\' || s.charAt(0) == '/')) {
                    s = "" + dosHack + ':' + s;
                } else {
                    URL u2 = FileUtil.urlForArchiveOrDir((File)new File(Character.toString(dosHack)));
                    if (u2 != null) {
                        l.add(u2);
                    }
                }
                dosHack = '\u0000';
            }
            delimCount = 0;
            if (s.length() == 1 && ((c = s.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                dosHack = c;
                continue;
            }
            URL u3 = FileUtil.urlForArchiveOrDir((File)new File(s));
            if (u3 == null) continue;
            l.add(u3);
        }
        if (dosHack != '\u0000' && (u = FileUtil.urlForArchiveOrDir((File)new File(Character.toString(dosHack)))) != null) {
            l.add(u);
        }
        return l;
    }

    private static String urlToString(URL url) {
        if ("jar".equals(url.getProtocol())) {
            URL fileURL = FileUtil.getArchiveFile((URL)url);
            if (FileUtil.getArchiveRoot((URL)fileURL).equals(url)) {
                url = fileURL;
            } else {
                return url.toExternalForm();
            }
        }
        if ("file".equals(url.getProtocol())) {
            File f = new File(URI.create(url.toExternalForm()));
            return f.getAbsolutePath();
        }
        return url.toExternalForm();
    }

    private static class PathView
    extends JPanel {
        private JList resources;
        private JButton addButton;
        private JButton addURLButton;
        private JButton removeButton;
        private JButton moveUpButton;
        private JButton moveDownButton;
        private File currentDir;
        private String type;

        public PathView(PathModel model, String type, File currentDir) {
            this.type = type;
            this.currentDir = currentDir;
            this.initComponents(model);
        }

        private void initComponents(PathModel model) {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            String key = null;
            String mneKey = null;
            String ad = null;
            if (this.type.equals(CustomizerSupport.CLASSPATH)) {
                key = "TXT_Classes";
                mneKey = "MNE_Classes";
                ad = "AD_Classes";
            } else if (this.type.equals(CustomizerSupport.SOURCES)) {
                key = "TXT_Sources";
                mneKey = "MNE_Sources";
                ad = "AD_Sources";
            } else if (this.type.equals(CustomizerSupport.JAVADOC)) {
                key = "TXT_Javadoc";
                mneKey = "MNE_Javadoc";
                ad = "AD_Javadoc";
            } else {
                assert (false) : "Illegal type of panel";
                return;
            }
            label.setText(NbBundle.getMessage(CustomizerSupport.class, (String)key));
            label.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSupport.class, (String)mneKey).charAt(0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.insets = new Insets(6, 12, 2, 0);
            c.fill = 2;
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            this.resources = new JList(model);
            label.setLabelFor(this.resources);
            this.resources.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSupport.class, (String)ad));
            this.resources.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.selectionChanged();
                }
            });
            JScrollPane spane = new JScrollPane(this.resources);
            spane.setPreferredSize(new Dimension(200, 100));
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 1;
            c.gridheight = 5;
            c.insets = new Insets(0, 12, 12, 6);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(spane, c);
            this.add(spane);
            if (this.type == CustomizerSupport.SOURCES || this.type == CustomizerSupport.JAVADOC) {
                char mne;
                String text;
                this.addButton = new JButton();
                if (this.type == CustomizerSupport.SOURCES) {
                    text = NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_Add");
                    mne = NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_Add").charAt(0);
                    ad = NbBundle.getMessage(CustomizerSupport.class, (String)"AD_Add");
                } else {
                    text = NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_AddZip");
                    mne = NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_AddZip").charAt(0);
                    ad = NbBundle.getMessage(CustomizerSupport.class, (String)"AD_AddZip");
                }
                this.addButton.setText(text);
                this.addButton.setMnemonic(mne);
                this.addButton.getAccessibleContext().setAccessibleDescription(ad);
                this.addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.addPathElement();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 1;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(0, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.addButton, c);
                this.add(this.addButton);
                this.removeButton = new JButton(NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_Remove"));
                this.removeButton.setMnemonic(NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_Remove").charAt(0));
                this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSupport.class, (String)"AD_Remove"));
                this.removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.removePathElement();
                    }
                });
                this.removeButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 3;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.removeButton, c);
                this.add(this.removeButton);
                this.moveUpButton = new JButton(NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_Up"));
                this.moveUpButton.setMnemonic(NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_Up").charAt(0));
                this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSupport.class, (String)"AD_Up"));
                this.moveUpButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.moveUpPathElement();
                    }
                });
                this.moveUpButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 4;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveUpButton, c);
                this.add(this.moveUpButton);
                this.moveDownButton = new JButton(NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_Down"));
                this.moveDownButton.setMnemonic(NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_Down").charAt(0));
                this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSupport.class, (String)"AD_Down"));
                this.moveDownButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.moveDownPathElement();
                    }
                });
                this.moveDownButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 5;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(5, 6, 6, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveDownButton, c);
                this.add(this.moveDownButton);
            }
        }

        private void addPathElement() {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(null);
            chooser.setMultiSelectionEnabled(true);
            String title = null;
            String message = null;
            String approveButtonName = null;
            String approveButtonNameMne = null;
            if (CustomizerSupport.SOURCES.equals(this.type)) {
                title = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_OpenSources");
                message = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_Sources");
                approveButtonName = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_OpenSources");
                approveButtonNameMne = NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_OpenSources");
            } else if (CustomizerSupport.JAVADOC.equals(this.type)) {
                title = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_OpenJavadoc");
                message = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_Javadoc");
                approveButtonName = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_OpenJavadoc");
                approveButtonNameMne = NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_OpenJavadoc");
            } else {
                throw new IllegalStateException("Can't add element for classpath");
            }
            chooser.setDialogTitle(title);
            chooser.setApproveButtonText(approveButtonName);
            chooser.setApproveButtonMnemonic(approveButtonNameMne.charAt(0));
            chooser.setFileSelectionMode(2);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new SimpleFileFilter(message, new String[]{"ZIP", "JAR"}));
            if (this.currentDir != null && this.currentDir.exists()) {
                chooser.setCurrentDirectory(this.currentDir);
            }
            if (chooser.showOpenDialog(this) == 0) {
                int lastIndex;
                File[] fs = chooser.getSelectedFiles();
                PathModel model = (PathModel)this.resources.getModel();
                boolean addingFailed = false;
                int firstIndex = this.resources.getModel().getSize();
                for (int i = 0; i < fs.length; ++i) {
                    File parent;
                    File f = fs[i];
                    if (!f.exists() && (parent = f.getParentFile()) != null && f.getName().equals(parent.getName()) && parent.exists()) {
                        f = parent;
                    }
                    addingFailed |= !model.addPath(f);
                }
                if (addingFailed) {
                    new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_CanNotAddResolve"), 0);
                }
                if (firstIndex <= (lastIndex = this.resources.getModel().getSize() - 1)) {
                    int[] toSelect = new int[lastIndex - firstIndex + 1];
                    for (int i = 0; i < toSelect.length; ++i) {
                        toSelect[i] = firstIndex + i;
                    }
                    this.resources.setSelectedIndices(toSelect);
                }
                this.currentDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
            }
        }

        private void removePathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.removePath(indices);
            if (indices[indices.length - 1] - indices.length + 1 < this.resources.getModel().getSize()) {
                this.resources.setSelectedIndex(indices[indices.length - 1] - indices.length + 1);
            } else if (indices[0] > 0) {
                this.resources.setSelectedIndex(indices[0] - 1);
            }
        }

        private void moveDownPathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.moveDownPath(indices);
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indices[i] + 1;
            }
            this.resources.setSelectedIndices(indices);
        }

        private void moveUpPathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.moveUpPath(indices);
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indices[i] - 1;
            }
            this.resources.setSelectedIndices(indices);
        }

        private void selectionChanged() {
            if (this.type == CustomizerSupport.CLASSPATH) {
                return;
            }
            int[] indices = this.resources.getSelectedIndices();
            this.removeButton.setEnabled(indices.length > 0);
            this.moveUpButton.setEnabled(indices.length > 0 && indices[0] > 0);
            this.moveDownButton.setEnabled(indices.length > 0 && indices[indices.length - 1] < this.resources.getModel().getSize() - 1);
        }
    }

    public static final class PathModel
    extends AbstractListModel {
        private final List<URL> data;

        public PathModel(List<URL> data) {
            if (data == null) {
                throw new NullPointerException("The data attribute must not be null.");
            }
            this.data = data;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int index) {
            URL url = this.data.get(index);
            if ("jar".equals(url.getProtocol())) {
                URL fileURL = FileUtil.getArchiveFile((URL)url);
                if (FileUtil.getArchiveRoot((URL)fileURL).equals(url)) {
                    url = fileURL;
                } else {
                    return url.toExternalForm();
                }
            }
            if ("file".equals(url.getProtocol())) {
                File f = new File(URI.create(url.toExternalForm()));
                return f.getAbsolutePath();
            }
            return url.toExternalForm();
        }

        public void removePath(int[] indices) {
            for (int i = indices.length - 1; i >= 0; --i) {
                this.data.remove(indices[i]);
            }
            this.fireIntervalRemoved(this, indices[0], indices[indices.length - 1]);
        }

        public void moveUpPath(int[] indices) {
            for (int i = 0; i < indices.length; ++i) {
                URL p2 = this.data.get(indices[i]);
                URL p1 = this.data.set(indices[i] - 1, p2);
                this.data.set(indices[i], p1);
            }
            this.fireContentsChanged(this, indices[0] - 1, indices[indices.length - 1]);
        }

        public void moveDownPath(int[] indices) {
            for (int i = indices.length - 1; i >= 0; --i) {
                URL p1 = this.data.get(indices[i]);
                URL p2 = this.data.set(indices[i] + 1, p1);
                this.data.set(indices[i], p2);
            }
            this.fireContentsChanged(this, indices[0], indices[indices.length - 1] + 1);
        }

        public boolean addPath(File f) {
            try {
                URL url = f.toURI().toURL();
                return this.addPath(url);
            }
            catch (MalformedURLException mue) {
                return false;
            }
        }

        public boolean addPath(URL url) {
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!url.toExternalForm().endsWith("/")) {
                try {
                    url = new URL(url.toExternalForm() + "/");
                }
                catch (MalformedURLException mue) {
                    Logger.getLogger("global").log(Level.INFO, null, mue);
                }
            }
            int oldSize = this.data.size();
            this.data.add(url);
            this.fireIntervalAdded(this, oldSize, oldSize);
            return true;
        }

        public List<URL> getData() {
            return this.data;
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

