/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.android;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.android.AndroidActionProvider;
import org.netbeans.modules.cordova.platforms.android.AndroidDevice;
import org.netbeans.modules.cordova.platforms.android.AndroidPlatform;
import org.netbeans.modules.cordova.platforms.android.Browser;
import org.netbeans.modules.cordova.platforms.android.Bundle;
import org.netbeans.modules.cordova.platforms.api.WebKitDebuggingSupport;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.WindowManager;

public class AndroidBrowser
extends HtmlBrowser.Impl
implements EnhancedBrowser {
    private final Kind kind;
    private static final Logger LOGGER = Logger.getLogger(AndroidBrowser.class.getName());
    private Lookup context;
    private URL url;

    public void initialize(WebBrowserFeatures browserFeatures) {
    }

    public void close(boolean closeTab) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                WebKitDebuggingSupport.getDefault().stopDebugging(true);
            }
        });
    }

    public void setProjectContext(Lookup projectContext) {
        this.context = projectContext;
    }

    public boolean canReloadPage() {
        return true;
    }

    public boolean ignoreChange(FileObject fo) {
        return BrowserSupport.ignoreChangeDefaultImpl((FileObject)fo);
    }

    public AndroidBrowser(Kind kind) {
        this.kind = kind;
    }

    public Component getComponent() {
        return null;
    }

    public void reloadDocument() {
        WebKitDebuggingSupport.getDefault().reload();
    }

    public void stopLoading() {
    }

    public void setURL(final URL url) {
        final WebKitDebuggingSupport build = WebKitDebuggingSupport.getDefault();
        final String checkAndroid = AndroidActionProvider.checkAndroid();
        if (checkAndroid != null) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ AndroidBrowser this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    NotifyDescriptor not = new NotifyDescriptor((Object)checkAndroid, Bundle.ERR_Title(), 2, 0, null, null);
                    Object value = DialogDisplayer.getDefault().notify(not);
                    if (NotifyDescriptor.CANCEL_OPTION != value) {
                        OptionsDisplayer.getDefault().open("Html5/MobilePlatforms");
                    }
                }
            });
            return;
        }
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){
            final /* synthetic */ AndroidBrowser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                boolean emulator;
                Browser b;
                String checkDevices = this.this$0.checkDevices();
                while (checkDevices != null) {
                    NotifyDescriptor not = new NotifyDescriptor((Object)checkDevices, Bundle.ERR_Title(), -1, 0, null, null);
                    Object value = DialogDisplayer.getDefault().notify(not);
                    if (NotifyDescriptor.CANCEL_OPTION == value || checkDevices.equals(Bundle.ERR_AdbNotFound())) {
                        return;
                    }
                    checkDevices = this.this$0.checkDevices();
                }
                if (this.this$0.kind == Kind.ANDROID_DEVICE_DEFAULT) {
                    b = Browser.DEFAULT;
                    emulator = false;
                } else if (this.this$0.kind == Kind.ANDROID_DEVICE_CHROME) {
                    b = Browser.CHROME;
                    emulator = false;
                } else {
                    b = Browser.DEFAULT;
                    emulator = true;
                }
                AndroidDevice device = new AndroidDevice("android", b, emulator);
                device.openUrl(url.toExternalForm());
                Project project = (Project)this.this$0.context.lookup(Project.class);
                if (Browser.CHROME.getName().equals(b.getName()) && project != null) {
                    try {
                        build.startDebugging((Device)device, project, (Lookup)new ProxyLookup(new Lookup[]{this.this$0.context, Lookups.fixed((Object[])new Object[]{BrowserFamilyId.ANDROID, ImageUtilities.loadImage((String)"org/netbeans/modules/cordova/platforms/android/androiddevice16.png"), url})}), false);
                    }
                    catch (IllegalStateException ex) {
                        LOGGER.log(Level.INFO, ex.getMessage(), ex);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), Bundle.ERR_WebDebug());
                            }
                        });
                    }
                }
            }
        }, (String)Bundle.LBL_CheckingDevice(), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
        this.url = url;
    }

    public static void openBrowser(String command, Lookup context, Kind kind, Project project, BrowserSupport support) throws IllegalArgumentException {
        WebKitDebuggingSupport build = WebKitDebuggingSupport.getDefault();
        if ("run".equals(command) || "run.single".equals(command)) {
            try {
                String urlString = build.getUrl(project, context);
                if (urlString == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_StartFileNotFound()));
                    CustomizerProvider2 cust = (CustomizerProvider2)project.getLookup().lookup(CustomizerProvider2.class);
                    cust.showCustomizer("RUN", null);
                    return;
                }
                URL urL = new URL(urlString);
                FileObject f = build.getFile(project, context);
                support.load(urL, f);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private String checkDevices() {
        if (!AndroidPlatform.getDefault().adbCommandExists()) {
            return Bundle.ERR_AdbNotFound();
        }
        try {
            if (this.kind == Kind.ANDROID_EMULATOR_DEFAULT) {
                for (Device dev : AndroidPlatform.getDefault().getConnectedDevices()) {
                    if (!dev.isEmulator()) continue;
                    return null;
                }
                return Bundle.ERR_RunAndroidEmulator();
            }
            for (Device dev : AndroidPlatform.getDefault().getConnectedDevices()) {
                if (dev.isEmulator()) continue;
                return null;
            }
            return Bundle.ERR_ConnectAndroidDevice();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Bundle.ERR_Unknown();
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getStatusMessage() {
        return "";
    }

    public String getTitle() {
        return Bundle.LBL_BrowserTitle();
    }

    public boolean isForward() {
        return false;
    }

    public void forward() {
    }

    public boolean isBackward() {
        return false;
    }

    public void backward() {
    }

    public boolean isHistory() {
        return false;
    }

    public void showHistory() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public static enum Kind {
        ANDROID_DEVICE_DEFAULT,
        ANDROID_DEVICE_CHROME,
        ANDROID_EMULATOR_DEFAULT;

    }
}

