/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.libraries.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.netbeans.spi.project.libraries.NamedLibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class ForwardingLibraryImplementation
implements LibraryImplementation,
NamedLibraryImplementation,
LibraryImplementation2,
LibraryImplementation3 {
    private final LibraryImplementation delegate;
    private final PropertyChangeSupport support;
    private final PropertyChangeListener listener;

    public ForwardingLibraryImplementation(@NonNull LibraryImplementation delegate) {
        Parameters.notNull((CharSequence)"delegate", (Object)delegate);
        this.delegate = delegate;
        this.support = new PropertyChangeSupport(this);
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ForwardingLibraryImplementation.this.support.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        this.delegate.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.delegate));
    }

    @NonNull
    public final LibraryImplementation getDelegate() {
        return this.delegate;
    }

    protected final void firePropertyChange(@NonNull String propName, @NullAllowed Object oldValue, @NullAllowed Object newValue) {
        this.support.firePropertyChange(propName, oldValue, newValue);
    }

    @Override
    public String getType() {
        return this.delegate.getType();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public String getLocalizingBundle() {
        return this.delegate.getLocalizingBundle();
    }

    @Override
    public List<URL> getContent(String volumeType) throws IllegalArgumentException {
        return this.delegate.getContent(volumeType);
    }

    @Override
    public void setName(String name) {
        this.delegate.setName(name);
    }

    @Override
    public void setDescription(String text) {
        this.delegate.setDescription(text);
    }

    @Override
    public void setLocalizingBundle(String resourceName) {
        this.delegate.setLocalizingBundle(resourceName);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    @Override
    public void setContent(String volumeType, List<URL> path) throws IllegalArgumentException {
        this.delegate.setContent(volumeType, path);
    }

    @Override
    public void setDisplayName(String displayName) {
        if (!LibrariesSupport.supportsDisplayName(this.delegate)) {
            throw new UnsupportedOperationException(String.format("Delegate: %s does not support displayName", this.delegate));
        }
        LibrariesSupport.setDisplayName(this.delegate, displayName);
    }

    @Override
    public String getDisplayName() {
        if (!LibrariesSupport.supportsDisplayName(this.delegate)) {
            throw new UnsupportedOperationException(String.format("Delegate: %s does not support displayName", this.delegate));
        }
        return LibrariesSupport.getDisplayName(this.delegate);
    }

    @Override
    public List<URI> getURIContent(String volumeType) throws IllegalArgumentException {
        if (!LibrariesSupport.supportsURIContent(this.delegate)) {
            throw new UnsupportedOperationException(String.format("Delegate: %s does not support URI content", this.delegate));
        }
        return LibrariesSupport.getURIContent(this.delegate, volumeType, LibrariesSupport.ConversionMode.FAIL);
    }

    @Override
    public void setURIContent(String volumeType, List<URI> path) throws IllegalArgumentException {
        if (!LibrariesSupport.supportsURIContent(this.delegate)) {
            throw new UnsupportedOperationException(String.format("Delegate: %s does not support URI content", this.delegate));
        }
        LibrariesSupport.setURIContent(this.delegate, volumeType, path, LibrariesSupport.ConversionMode.FAIL);
    }

    @Override
    public Map<String, String> getProperties() {
        if (!LibrariesSupport.supportsProperties(this.delegate)) {
            throw new UnsupportedOperationException(String.format("Delegate: %s does not support properties", this.delegate));
        }
        return LibrariesSupport.getProperties(this.delegate);
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        if (!LibrariesSupport.supportsProperties(this.delegate)) {
            throw new UnsupportedOperationException(String.format("Delegate: %s does not support properties", this.delegate));
        }
        LibrariesSupport.setProperties(this.delegate, properties);
    }
}

