/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInstanceConsoleConnectionRequest
extends BmcRequest<Void> {
    private String instanceConsoleConnectionId;

    public String getInstanceConsoleConnectionId() {
        return this.instanceConsoleConnectionId;
    }

    public Builder toBuilder() {
        return new Builder().instanceConsoleConnectionId(this.instanceConsoleConnectionId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceConsoleConnectionId=").append(String.valueOf(this.instanceConsoleConnectionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInstanceConsoleConnectionRequest)) {
            return false;
        }
        GetInstanceConsoleConnectionRequest other = (GetInstanceConsoleConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceConsoleConnectionId, other.instanceConsoleConnectionId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceConsoleConnectionId == null ? 43 : this.instanceConsoleConnectionId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInstanceConsoleConnectionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceConsoleConnectionId = null;

        public Builder instanceConsoleConnectionId(String instanceConsoleConnectionId) {
            this.instanceConsoleConnectionId = instanceConsoleConnectionId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceConsoleConnectionRequest o) {
            this.instanceConsoleConnectionId(o.getInstanceConsoleConnectionId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceConsoleConnectionRequest build() {
            GetInstanceConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInstanceConsoleConnectionRequest buildWithoutInvocationCallback() {
            GetInstanceConsoleConnectionRequest request = new GetInstanceConsoleConnectionRequest();
            request.instanceConsoleConnectionId = this.instanceConsoleConnectionId;
            return request;
        }
    }
}

