/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.LongAdder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.rest.StatusType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public abstract class AbstractStatusStats
implements Writeable,
ToXContentFragment {
    protected final LongAdder[] statusCounter;

    public AbstractStatusStats() {
        this.statusCounter = new LongAdder[5];
        for (int i = 0; i < this.statusCounter.length; ++i) {
            this.statusCounter[i] = new LongAdder();
        }
    }

    public AbstractStatusStats(StreamInput in) throws IOException {
        this.statusCounter = (LongAdder[])in.readArray(i -> {
            LongAdder adder = new LongAdder();
            adder.add(i.readLong());
            return adder;
        }, LongAdder[]::new);
        assert (this.statusCounter.length == 5) : "Length of incoming array should be 5! Got " + this.statusCounter.length;
    }

    public void inc(RestStatus status) {
        this.add(status, 1L);
    }

    public void add(RestStatus status, long delta) {
        this.statusCounter[status.getStatusFamilyCode() - 1].add(delta);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        HashMap<String, Long> errorTypeCounts = new HashMap<String, Long>();
        for (int i = 0; i < this.statusCounter.length; ++i) {
            long count = this.statusCounter[i].longValue();
            if (count <= 0L) continue;
            RestStatus familyStatus = RestStatus.fromCode((int)((i + 1) * 100));
            String errorType = familyStatus.getStatusType();
            errorTypeCounts.put(errorType, errorTypeCounts.getOrDefault(errorType, 0L) + count);
        }
        String successType = StatusType.SUCCESS.toString();
        String userFailureType = StatusType.USER_ERROR.toString();
        String systemErrorType = StatusType.SYSTEM_FAILURE.toString();
        builder.field(successType, errorTypeCounts.getOrDefault(successType, 0L));
        builder.field(userFailureType, errorTypeCounts.getOrDefault(userFailureType, 0L));
        builder.field(systemErrorType, errorTypeCounts.getOrDefault(systemErrorType, 0L));
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((o, v) -> o.writeLong(v.longValue()), (Object[])this.statusCounter);
    }
}

