/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.fieldcaps;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class IndexFieldCapabilities
implements Writeable {
    private final String name;
    private final String type;
    private final boolean isSearchable;
    private final boolean isAggregatable;
    private final Map<String, String> meta;

    IndexFieldCapabilities(String name, String type, boolean isSearchable, boolean isAggregatable, Map<String, String> meta) {
        this.name = name;
        this.type = type;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.meta = meta;
    }

    IndexFieldCapabilities(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.isSearchable = in.readBoolean();
        this.isAggregatable = in.readBoolean();
        this.meta = in.readMap(StreamInput::readString, StreamInput::readString);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.isSearchable);
        out.writeBoolean(this.isAggregatable);
        out.writeMap(this.meta, StreamOutput::writeString, StreamOutput::writeString);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFieldCapabilities that = (IndexFieldCapabilities)o;
        return this.isSearchable == that.isSearchable && this.isAggregatable == that.isAggregatable && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.isSearchable, this.isAggregatable, this.meta);
    }
}

