/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.compress.Compressor;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumWritableBlobStoreFormat;

public class RemoteDiscoveryNodes
extends AbstractClusterMetadataWriteableBlobEntity<DiscoveryNodes> {
    public static final String DISCOVERY_NODES = "nodes";
    public final ChecksumWritableBlobStoreFormat<DiscoveryNodes> discoveryNodesFormat;
    private DiscoveryNodes discoveryNodes;
    private long stateVersion;

    public RemoteDiscoveryNodes(DiscoveryNodes discoveryNodes, long stateVersion, String clusterUUID, Compressor compressor) {
        super(clusterUUID, compressor, null);
        this.discoveryNodes = discoveryNodes;
        this.stateVersion = stateVersion;
        this.discoveryNodesFormat = new ChecksumWritableBlobStoreFormat(DISCOVERY_NODES, is -> DiscoveryNodes.readFrom(is, null));
    }

    public RemoteDiscoveryNodes(String blobName, String clusterUUID, Compressor compressor, Version version) {
        super(clusterUUID, compressor, null);
        this.blobName = blobName;
        this.discoveryNodesFormat = new ChecksumWritableBlobStoreFormat(DISCOVERY_NODES, is -> DiscoveryNodes.readFrom(is, null), version);
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of("ephemeral"), DISCOVERY_NODES);
    }

    @Override
    public String getType() {
        return DISCOVERY_NODES;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.stateVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(DISCOVERY_NODES, this.blobName);
    }

    @Override
    public InputStream serialize() throws IOException {
        return this.discoveryNodesFormat.serialize((Writeable.Writer<DiscoveryNodes>)((Writeable.Writer)(out, discoveryNode) -> discoveryNode.writeToWithAttribute(out)), this.discoveryNodes, this.generateBlobFileName(), this.getCompressor()).streamInput();
    }

    @Override
    public DiscoveryNodes deserialize(InputStream inputStream) throws IOException {
        return this.discoveryNodesFormat.deserialize(this.blobName, Streams.readFully(inputStream));
    }
}

