/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.plan.rule;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.plan.rel.LogicalDedup;
import org.opensearch.sql.calcite.plan.rule.ImmutablePPLDedupConvertRule;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRuleConfig;

@Value.Enclosing
public class PPLDedupConvertRule
extends RelRule<Config> {
    public static final PPLDedupConvertRule DEDUP_CONVERT_RULE = Config.DEDUP_CONVERTER.toRule();

    protected PPLDedupConvertRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalDedup dedup = (LogicalDedup)call.rel(0);
        RelBuilder relBuilder = call.builder();
        relBuilder.push(dedup.getInput());
        if (dedup.getKeepEmpty().booleanValue()) {
            PPLDedupConvertRule.buildDedupOrNull(relBuilder, dedup.getDedupeFields(), dedup.getAllowedDuplication());
        } else {
            PPLDedupConvertRule.buildDedupNotNull(relBuilder, dedup.getDedupeFields(), dedup.getAllowedDuplication());
        }
        call.transformTo(relBuilder.build());
    }

    public static void buildDedupOrNull(RelBuilder relBuilder, List<RexNode> dedupeFields, Integer allowedDuplication) {
        RexNode rowNumber = relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().partitionBy(dedupeFields).rowsTo(RexWindowBounds.CURRENT_ROW).as("_row_number_dedup_");
        relBuilder.projectPlus(new RexNode[]{rowNumber});
        RexInputRef _row_number_dedup_ = relBuilder.field("_row_number_dedup_");
        RexNode[] rexNodeArray = new RexNode[1];
        RexNode[] rexNodeArray2 = new RexNode[2];
        rexNodeArray2[0] = relBuilder.or((Iterable)dedupeFields.stream().map(arg_0 -> ((RelBuilder)relBuilder).isNull(arg_0)).collect(Collectors.toList()));
        rexNodeArray2[1] = relBuilder.lessThanOrEqual((RexNode)_row_number_dedup_, (RexNode)relBuilder.literal((Object)allowedDuplication));
        rexNodeArray[0] = relBuilder.or(rexNodeArray2);
        relBuilder.filter(rexNodeArray);
        relBuilder.projectExcept(new RexNode[]{_row_number_dedup_});
    }

    public static void buildDedupNotNull(RelBuilder relBuilder, List<RexNode> dedupeFields, Integer allowedDuplication) {
        String rowNumberAlias = "_row_number_dedup_";
        RexNode[] rexNodeArray = new RexNode[1];
        rexNodeArray[0] = relBuilder.and((Iterable)dedupeFields.stream().map(arg_0 -> ((RelBuilder)relBuilder).isNotNull(arg_0)).collect(Collectors.toList()));
        relBuilder.filter(rexNodeArray);
        RexNode rowNumber = relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().partitionBy(dedupeFields).rowsTo(RexWindowBounds.CURRENT_ROW).as(rowNumberAlias);
        relBuilder.projectPlus(new RexNode[]{rowNumber});
        RexInputRef rowNumberField = relBuilder.field(rowNumberAlias);
        relBuilder.filter(new RexNode[]{relBuilder.lessThanOrEqual((RexNode)rowNumberField, (RexNode)relBuilder.literal((Object)allowedDuplication))});
        relBuilder.projectExcept(new RexNode[]{rowNumberField});
    }

    @Value.Immutable
    public static interface Config
    extends OpenSearchRuleConfig {
        public static final Config DEDUP_CONVERTER = ImmutablePPLDedupConvertRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalDedup.class).anyInputs());

        default public PPLDedupConvertRule toRule() {
            return new PPLDedupConvertRule(this);
        }
    }
}

