/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.collector;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.planner.physical.collector.Collector;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;

public class MetricCollector
implements Collector {
    private final List<Map.Entry<NamedAggregator, AggregationState>> aggregators;

    public MetricCollector(List<NamedAggregator> aggregators) {
        this.aggregators = aggregators.stream().map(aggregator -> new AbstractMap.SimpleEntry<NamedAggregator, AggregationState>((NamedAggregator)aggregator, aggregator.create())).collect(Collectors.toList());
    }

    @Override
    public void collect(BindingTuple input) {
        this.aggregators.forEach(agg -> ((NamedAggregator)agg.getKey()).iterate(input, (AggregationState)agg.getValue()));
    }

    @Override
    public List<ExprValue> results() {
        LinkedHashMap<String, ExprValue> map = new LinkedHashMap<String, ExprValue>();
        this.aggregators.forEach(agg -> map.put(((NamedAggregator)agg.getKey()).getName(), ((AggregationState)agg.getValue()).result()));
        return Collections.singletonList(ExprTupleValue.fromExprValueMap(map));
    }
}

