/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.autofollow;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.persistent.AllocatedPersistentTask;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.replication.ReplicationSettings;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.task.CrossClusterReplicationTask;
import org.opensearch.replication.task.autofollow.AutoFollowParams;
import org.opensearch.replication.task.autofollow.AutoFollowTask;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJJ\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001bH\u0014J\u0016\u0010\u001c\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0014J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00022\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/opensearch/replication/task/autofollow/AutoFollowExecutor;", "Lorg/opensearch/persistent/PersistentTasksExecutor;", "Lorg/opensearch/replication/task/autofollow/AutoFollowParams;", "executor", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "client", "Lorg/opensearch/transport/client/Client;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "(Ljava/lang/String;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/transport/client/Client;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;Lorg/opensearch/replication/ReplicationSettings;)V", "createTask", "Lorg/opensearch/persistent/AllocatedPersistentTask;", "id", "", "type", "action", "parentTaskId", "Lorg/opensearch/core/tasks/TaskId;", "taskInProgress", "Lorg/opensearch/persistent/PersistentTasksCustomMetadata$PersistentTask;", "headers", "", "getDescription", "nodeOperation", "", "task", "params", "state", "Lorg/opensearch/persistent/PersistentTaskState;", "Companion", "opensearch-cross-cluster-replication"})
public final class AutoFollowExecutor
extends PersistentTasksExecutor<AutoFollowParams> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final Client client;
    @NotNull
    private final ReplicationMetadataManager replicationMetadataManager;
    @NotNull
    private final ReplicationSettings replicationSettings;
    @NotNull
    public static final String TASK_NAME = "cluster:admin/plugins/replication/autofollow";

    public AutoFollowExecutor(@NotNull String executor, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull Client client, @NotNull ReplicationMetadataManager replicationMetadataManager, @NotNull ReplicationSettings replicationSettings) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        Intrinsics.checkNotNullParameter((Object)replicationSettings, (String)"replicationSettings");
        super(TASK_NAME, executor);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.replicationMetadataManager = replicationMetadataManager;
        this.replicationSettings = replicationSettings;
    }

    protected void nodeOperation(@NotNull AllocatedPersistentTask task, @NotNull AutoFollowParams params, @Nullable PersistentTaskState state) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (task instanceof AutoFollowTask) {
            CrossClusterReplicationTask.run$default((CrossClusterReplicationTask)task, null, 1, null);
        } else {
            task.markAsFailed((Exception)new IllegalArgumentException("unknown task type : " + task.getClass()));
        }
    }

    @NotNull
    protected AllocatedPersistentTask createTask(long id, @NotNull String type, @NotNull String action, @NotNull TaskId parentTaskId, @NotNull PersistentTasksCustomMetadata.PersistentTask<AutoFollowParams> taskInProgress, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)parentTaskId, (String)"parentTaskId");
        Intrinsics.checkNotNullParameter(taskInProgress, (String)"taskInProgress");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String string = this.getDescription(taskInProgress);
        String string2 = this.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExecutor(...)");
        PersistentTaskParams persistentTaskParams = taskInProgress.getParams();
        Intrinsics.checkNotNull((Object)persistentTaskParams);
        return new AutoFollowTask(id, type, action, string, parentTaskId, headers, string2, this.clusterService, this.threadPool, this.client, this.replicationMetadataManager, (AutoFollowParams)persistentTaskParams, this.replicationSettings);
    }

    @NotNull
    protected String getDescription(@NotNull PersistentTasksCustomMetadata.PersistentTask<AutoFollowParams> taskInProgress) {
        Intrinsics.checkNotNullParameter(taskInProgress, (String)"taskInProgress");
        AutoFollowParams autoFollowParams = (AutoFollowParams)taskInProgress.getParams();
        AutoFollowParams autoFollowParams2 = (AutoFollowParams)taskInProgress.getParams();
        return "replication auto follow task for leader cluster: " + (autoFollowParams != null ? autoFollowParams.getLeaderCluster() : null) + " with pattern " + (autoFollowParams2 != null ? autoFollowParams2.getPatternName() : null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/replication/task/autofollow/AutoFollowExecutor$Companion;", "", "()V", "TASK_NAME", "", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

