"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFlexItem", {
  enumerable: true,
  get: function get() {
    return _flex_item.EuiFlexItem;
  }
});
exports.OuiFlexItem = exports.GROW_SIZES = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _flex_item = require("../../eui_components/flex/flex_item");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var GROW_SIZES = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
exports.GROW_SIZES = GROW_SIZES;
var OuiFlexItem = function OuiFlexItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "grow", "component"]);
  validateGrowValue(grow);
  var classes = (0, _classnames.default)('ouiFlexItem', (0, _defineProperty2.default)({
    'ouiFlexItem--flexGrowZero': !grow
  }, "ouiFlexItem--flexGrow".concat(grow), typeof grow === 'number' ? GROW_SIZES.indexOf(grow) >= 0 : undefined), className);
  return (
    /*#__PURE__*/
    // @ts-ignore difficult to verify `rest` applies to `Component`
    _react.default.createElement(Component, (0, _extends2.default)({
      className: classes
    }, rest), children)
  );
};
exports.OuiFlexItem = OuiFlexItem;
OuiFlexItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  grow: _propTypes.default.oneOf([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, true, false, null]),
  component: _propTypes.default.any
};
function validateGrowValue(value) {
  var validValues = [null, undefined, true, false].concat(GROW_SIZES);
  if (validValues.indexOf(value) === -1) {
    throw new Error("Prop `grow` passed to `OuiFlexItem` must be a boolean or an integer between 1 and 10, received `".concat(value, "`"));
  }
}

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */