/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGateway;
import software.amazon.awssdk.services.ec2.model.TransitGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewaysResponse> {
    private static final SdkField<List<TransitGateway>> TRANSIT_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGateways").getter(DescribeTransitGatewaysResponse.getter(DescribeTransitGatewaysResponse::transitGateways)).setter(DescribeTransitGatewaysResponse.setter(Builder::transitGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewaySet").unmarshallLocationName("transitGatewaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewaysResponse.getter(DescribeTransitGatewaysResponse::nextToken)).setter(DescribeTransitGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAYS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTransitGatewaysResponse.memberNameToFieldInitializer();
    private final List<TransitGateway> transitGateways;
    private final String nextToken;

    private DescribeTransitGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.transitGateways = builder.transitGateways;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGateways() {
        return this.transitGateways != null && !(this.transitGateways instanceof SdkAutoConstructList);
    }

    public final List<TransitGateway> transitGateways() {
        return this.transitGateways;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGateways() ? this.transitGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewaysResponse)) {
            return false;
        }
        DescribeTransitGatewaysResponse other = (DescribeTransitGatewaysResponse)((Object)obj);
        return this.hasTransitGateways() == other.hasTransitGateways() && Objects.equals(this.transitGateways(), other.transitGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTransitGatewaysResponse").add("TransitGateways", this.hasTransitGateways() ? this.transitGateways() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGateways": {
                return Optional.ofNullable(clazz.cast(this.transitGateways()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewaySet", TRANSIT_GATEWAYS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGateway> transitGateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewaysResponse model) {
            super(model);
            this.transitGateways(model.transitGateways);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGateway.Builder> getTransitGateways() {
            List<TransitGateway.Builder> result = TransitGatewayListCopier.copyToBuilder(this.transitGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGateways(Collection<TransitGateway.BuilderImpl> transitGateways) {
            this.transitGateways = TransitGatewayListCopier.copyFromBuilder(transitGateways);
        }

        @Override
        public final Builder transitGateways(Collection<TransitGateway> transitGateways) {
            this.transitGateways = TransitGatewayListCopier.copy(transitGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGateways(TransitGateway ... transitGateways) {
            this.transitGateways(Arrays.asList(transitGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGateways(Consumer<TransitGateway.Builder> ... transitGateways) {
            this.transitGateways(Stream.of(transitGateways).map(c -> (TransitGateway)((TransitGateway.Builder)TransitGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTransitGatewaysResponse build() {
            return new DescribeTransitGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewaysResponse> {
        public Builder transitGateways(Collection<TransitGateway> var1);

        public Builder transitGateways(TransitGateway ... var1);

        public Builder transitGateways(Consumer<TransitGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

