/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OrtException;
import ai.onnxruntime.ValueInfo;
import java.util.Map;

public interface OnnxValue
extends AutoCloseable {
    public OnnxValueType getType();

    public Object getValue() throws OrtException;

    public ValueInfo getInfo();

    @Override
    public void close();

    public static void close(Iterable<? extends OnnxValue> itr) {
        for (OnnxValue onnxValue : itr) {
            onnxValue.close();
        }
    }

    public static void close(Map<String, ? extends OnnxValue> map) {
        for (OnnxValue onnxValue : map.values()) {
            onnxValue.close();
        }
    }

    public static enum OnnxValueType {
        ONNX_TYPE_UNKNOWN(0),
        ONNX_TYPE_TENSOR(1),
        ONNX_TYPE_SEQUENCE(2),
        ONNX_TYPE_MAP(3),
        ONNX_TYPE_OPAQUE(4),
        ONNX_TYPE_SPARSETENSOR(5),
        ONNX_TYPE_OPTIONAL(6);

        public final int value;

        private OnnxValueType(int value) {
            this.value = value;
        }
    }
}

