/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.SHACAL2;
import org.bouncycastle.jcajce.provider.ASN1AlgorithmParameters;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GcmSpecUtil;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.IvParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.SymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSHACAL2
extends SymmetricAlgorithmProvider {
    private static final String PREFIX = ProvSHACAL2.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvSHACAL2() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        final Class[] classArray = GcmSpecUtil.getCipherSpecClasses();
        final SHACAL2.OperatorFactory operatorFactory = new SHACAL2.OperatorFactory();
        final SHACAL2.AEADOperatorFactory aEADOperatorFactory = new SHACAL2.AEADOperatorFactory();
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.SHACAL-2", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 256, SHACAL2.ECBwithPKCS7, SHACAL2.ECB, SHACAL2.ECBwithISO10126_2, SHACAL2.ECBwithISO7816_4, SHACAL2.ECBwithTBC, SHACAL2.ECBwithX923, SHACAL2.CBC, SHACAL2.CBCwithPKCS7, SHACAL2.CBCwithISO10126_2, SHACAL2.CBCwithISO7816_4, SHACAL2.CBCwithTBC, SHACAL2.CBCwithX923, SHACAL2.CBCwithCS1, SHACAL2.CBCwithCS2, SHACAL2.CBCwithCS3, SHACAL2.CFB256, SHACAL2.CFB8, SHACAL2.OFB, SHACAL2.CTR, SHACAL2.EAX).withGeneralOperators(ProvSHACAL2.this.generalParametersCreatorProvider, operatorFactory, aEADOperatorFactory).withParameters(classArray).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "SHACAL-2", "SHACAL2");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SHACAL-2", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "SHACAL-2", 128, false, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new SHACAL2.KeyGenerator(n, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "SHACAL-2", "SHACAL2");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.SHACAL-2", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("SHACAL-2");
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "SHACAL-2", "SHACAL2");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SHACAL-2CMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(SHACAL2.CMAC, (MACOperatorFactory)new SHACAL2.MACOperatorFactory(), new AuthParametersCreator(SHACAL2.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "SHACAL-2CMAC", "SHACAL-2-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.SHACAL-2", PREFIX + "$SHACAL2KFACT", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("SHACAL-2", SHACAL2.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    @Override
                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n == 0 || n > 512 || n < 128 || n % 64 != 0) {
                            throw new InvalidKeySpecException("SHACAL-2 key must be 128 - 512 bits and a multiple of 64");
                        }
                        return byArray;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "SHACAL-2", "SHACAL2");
    }
}

