/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FSImageTransactionalStorageInspector
extends FSImageStorageInspector {
    public static final Logger LOG = LoggerFactory.getLogger(FSImageTransactionalStorageInspector.class);
    private boolean needToSave = false;
    private boolean isUpgradeFinalized = true;
    final List<FSImageStorageInspector.FSImageFile> foundImages = new ArrayList<FSImageStorageInspector.FSImageFile>();
    private long maxSeenTxId = 0L;
    private final List<Pattern> namePatterns = Lists.newArrayList();

    FSImageTransactionalStorageInspector() {
        this(EnumSet.of(NNStorage.NameNodeFile.IMAGE));
    }

    FSImageTransactionalStorageInspector(EnumSet<NNStorage.NameNodeFile> nnfs) {
        for (NNStorage.NameNodeFile nnf : nnfs) {
            Pattern pattern = Pattern.compile(nnf.getName() + "_(\\d+)");
            this.namePatterns.add(pattern);
        }
    }

    private Matcher matchPattern(String name) {
        for (Pattern p : this.namePatterns) {
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            return m;
        }
        return null;
    }

    @Override
    public void inspectDirectory(Storage.StorageDirectory sd) throws IOException {
        File[] filesInStorage;
        if (!sd.getVersionFile().exists()) {
            LOG.info("No version file in " + sd.getRoot());
            this.needToSave |= true;
            return;
        }
        try {
            this.maxSeenTxId = Math.max(this.maxSeenTxId, NNStorage.readTransactionIdFile(sd));
        }
        catch (IOException ioe) {
            LOG.warn("Unable to determine the max transaction ID seen by " + sd, (Throwable)ioe);
            return;
        }
        File currentDir = sd.getCurrentDir();
        try {
            filesInStorage = FileUtil.listFiles((File)currentDir);
        }
        catch (IOException ioe) {
            LOG.warn("Unable to inspect storage directory " + currentDir, (Throwable)ioe);
            return;
        }
        for (File f : filesInStorage) {
            LOG.debug("Checking file " + f);
            String name = f.getName();
            Matcher imageMatch = this.matchPattern(name);
            if (imageMatch == null) continue;
            if (sd.getStorageDirType().isOfType(NNStorage.NameNodeDirType.IMAGE)) {
                try {
                    long txid = Long.parseLong(imageMatch.group(1));
                    this.foundImages.add(new FSImageStorageInspector.FSImageFile(sd, f, txid));
                }
                catch (NumberFormatException nfe) {
                    LOG.error("Image file " + f + " has improperly formatted transaction ID");
                }
                continue;
            }
            LOG.warn("Found image file at " + f + " but storage directory is not configured to contain images.");
        }
        this.isUpgradeFinalized = this.isUpgradeFinalized && !sd.getPreviousDir().exists();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.isUpgradeFinalized;
    }

    @Override
    List<FSImageStorageInspector.FSImageFile> getLatestImages() throws IOException {
        LinkedList<FSImageStorageInspector.FSImageFile> ret = new LinkedList<FSImageStorageInspector.FSImageFile>();
        for (FSImageStorageInspector.FSImageFile img : this.foundImages) {
            if (ret.isEmpty()) {
                ret.add(img);
                continue;
            }
            FSImageStorageInspector.FSImageFile cur = ret.getFirst();
            if (cur.txId == img.txId) {
                ret.add(img);
                continue;
            }
            if (cur.txId >= img.txId) continue;
            ret.clear();
            ret.add(img);
        }
        if (ret.isEmpty()) {
            throw new FileNotFoundException("No valid image files found");
        }
        return ret;
    }

    public List<FSImageStorageInspector.FSImageFile> getFoundImages() {
        return ImmutableList.copyOf(this.foundImages);
    }

    @Override
    public boolean needToSave() {
        return this.needToSave;
    }

    @Override
    long getMaxSeenTxId() {
        return this.maxSeenTxId;
    }
}

