/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.Key;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyMap;
import net.shibboleth.shared.collection.LazySet;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.KeyInfo;

public class KeyInfoResolutionContext {
    @Nullable
    private KeyInfo keyInfo;
    @Nonnull
    @Live
    private final Set<String> keyNames;
    @Nullable
    private Key key;
    @Nonnull
    private final Collection<Credential> resolvedCredentials;
    @Nonnull
    @Live
    private final Map<String, Object> properties;

    public KeyInfoResolutionContext(@Nonnull @ParameterName(name="credentials") Collection<Credential> credentials) {
        this.resolvedCredentials = CollectionSupport.copyToList(credentials);
        this.properties = new LazyMap<String, Object>();
        this.keyNames = new LazySet<String>();
    }

    @Nullable
    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(@Nullable KeyInfo newKeyInfo) {
        this.keyInfo = newKeyInfo;
    }

    @Nonnull
    @Live
    public Set<String> getKeyNames() {
        return this.keyNames;
    }

    @Nullable
    public Key getKey() {
        return this.key;
    }

    public void setKey(@Nullable Key newKey) {
        this.key = newKey;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<Credential> getResolvedCredentials() {
        return this.resolvedCredentials;
    }

    @Nonnull
    @Live
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

