/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.PragmaKey;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public abstract class AbstractEntityDiagram
extends CucaDiagram {
    public AbstractEntityDiagram(UmlSource source, UmlDiagramType type, Previous previous, PreprocessingArtifact preprocessing) {
        super(source, type, previous, preprocessing);
    }

    @Override
    protected final List<String> getDotStrings() {
        List<String> def = Arrays.asList("nodesep=.35;", "ranksep=0.8;", "edge [fontsize=11,labelfontsize=11];", "node [fontsize=11,height=.35,width=.55];");
        if (!this.getPragma().isDefine(PragmaKey.GRAPH_ATTRIBUTES)) {
            return def;
        }
        String attribute = this.getPragma().getValue(PragmaKey.GRAPH_ATTRIBUTES);
        ArrayList<String> result = new ArrayList<String>(def);
        result.add(attribute);
        return Collections.unmodifiableList(result);
    }

    @Override
    public final DiagramDescription getDescription() {
        String id;
        StringBuilder result = new StringBuilder("(" + this.leafs().size() + " entities");
        if (this.getSource() != null && (id = this.getSource().getId()) != null) {
            result.append(", ");
            result.append(id);
        }
        result.append(")");
        return new DiagramDescription(result.toString());
    }

    protected final void packSomePackage() {
        boolean changed;
        String separator = this.getNamespaceSeparator();
        if (separator == null) {
            separator = ".";
        }
        do {
            changed = false;
            for (Entity group : this.groups()) {
                if (!group.canBePacked()) continue;
                Entity child = group.groups().iterator().next();
                String appended = group.getDisplay().get(0) + separator;
                Display newDisplay = child.getDisplay().appendFirstLine(appended);
                child.setDisplay(newDisplay);
                group.setPacked(true);
                changed = true;
            }
        } while (changed);
    }
}

