/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.wrapping.BreakingPointInserter;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineSegment;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class BreakingPointRemover
implements ILayoutProcessor<LGraph> {
    private EdgeRouting edgeRouting;

    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Breaking Point Removing", 1.0f);
        this.edgeRouting = graph.getProperty(LayeredOptions.EDGE_ROUTING);
        for (Layer l : graph.getLayers()) {
            for (LNode node : Lists.newArrayList(l.getNodes())) {
                if (!BreakingPointInserter.BPInfo.isEnd(node)) continue;
                BreakingPointInserter.BPInfo bpi = node.getProperty(InternalProperties.BREAKING_POINT_INFO);
                if (bpi.next != null) continue;
                this.remove(graph, bpi);
            }
        }
        progressMonitor.done();
    }

    private void remove(LGraph graph, BreakingPointInserter.BPInfo bpi) {
        KVectorChain newBends = new KVectorChain();
        switch (this.edgeRouting) {
            case SPLINES: {
                List<SplineSegment> s1 = bpi.nodeStartEdge.getProperty(InternalProperties.SPLINE_ROUTE_START);
                List<SplineSegment> s2 = bpi.startEndEdge.getProperty(InternalProperties.SPLINE_ROUTE_START);
                List<SplineSegment> s3 = bpi.originalEdge.getProperty(InternalProperties.SPLINE_ROUTE_START);
                List<LEdge> e1 = bpi.nodeStartEdge.getProperty(InternalProperties.SPLINE_EDGE_CHAIN);
                List<LEdge> e2 = bpi.startEndEdge.getProperty(InternalProperties.SPLINE_EDGE_CHAIN);
                List<LEdge> e3 = bpi.originalEdge.getProperty(InternalProperties.SPLINE_EDGE_CHAIN);
                ArrayList<SplineSegment> joinedSegments = Lists.newArrayList();
                joinedSegments.addAll(s1);
                s2.forEach(s -> {
                    boolean bl = s.inverseOrder = true;
                });
                joinedSegments.addAll(Lists.reverse(s2));
                joinedSegments.addAll(s3);
                ArrayList<LEdge> joinedEdges = Lists.newArrayList();
                joinedEdges.addAll(e1);
                joinedEdges.addAll(Lists.reverse(e2));
                joinedEdges.addAll(e3);
                bpi.originalEdge.setProperty(InternalProperties.SPLINE_ROUTE_START, joinedSegments);
                bpi.originalEdge.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, joinedEdges);
                bpi.originalEdge.setProperty(InternalProperties.SPLINE_SURVIVING_EDGE, bpi.originalEdge);
                bpi.nodeStartEdge.setProperty(InternalProperties.SPLINE_ROUTE_START, (Object)null);
                bpi.nodeStartEdge.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, (Object)null);
                bpi.startEndEdge.setProperty(InternalProperties.SPLINE_ROUTE_START, (Object)null);
                bpi.startEndEdge.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, (Object)null);
                break;
            }
            case POLYLINE: {
                newBends.addAll(bpi.nodeStartEdge.getBendPoints());
                newBends.add(bpi.start.getPosition());
                newBends.addAll(Lists.reverse(bpi.startEndEdge.getBendPoints()));
                newBends.add(bpi.end.getPosition());
                newBends.addAll(bpi.originalEdge.getBendPoints());
                break;
            }
            default: {
                newBends.addAll(bpi.nodeStartEdge.getBendPoints());
                newBends.addAll(Lists.reverse(bpi.startEndEdge.getBendPoints()));
                newBends.addAll(bpi.originalEdge.getBendPoints());
            }
        }
        bpi.originalEdge.getBendPoints().clear();
        bpi.originalEdge.getBendPoints().addAll(newBends);
        bpi.originalEdge.setSource(bpi.nodeStartEdge.getSource());
        KVectorChain junctionPointsOne = bpi.nodeStartEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
        KVectorChain junctionPointsTwo = bpi.startEndEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
        KVectorChain junctionPointsThree = bpi.originalEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
        if (junctionPointsOne != null || junctionPointsTwo != null || junctionPointsThree != null) {
            KVectorChain newJunctionPoints = new KVectorChain();
            this.addNullSafe(newJunctionPoints, junctionPointsThree);
            this.addNullSafe(newJunctionPoints, junctionPointsTwo);
            this.addNullSafe(newJunctionPoints, junctionPointsOne);
            bpi.originalEdge.setProperty(LayeredOptions.JUNCTION_POINTS, newJunctionPoints);
        }
        bpi.startEndEdge.setSource(null);
        bpi.startEndEdge.setTarget(null);
        bpi.nodeStartEdge.setSource(null);
        bpi.nodeStartEdge.setTarget(null);
        bpi.end.setLayer(null);
        bpi.start.setLayer(null);
        if (bpi.prev != null) {
            this.remove(graph, bpi.prev);
        }
    }

    private <T> boolean addNullSafe(Collection<T> container, Collection<T> toAdd) {
        if (container == null || toAdd == null) {
            return false;
        }
        return container.addAll(toAdd);
    }
}

