# MicroBenchmark
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-9)</span>

Synchronous benchmarks must provide this trait. The `apply` method defines a
single iteration in a sample. Setup and Teardown are defined by the `before`
and `after` methods respectively. The `before` method runs before a sample
of benchmarks and `after` runs after the all iterations in the sample have
completed. If your benchmark requires setup and/or teardown to occur beween
each iteration of the benchmark, then you can use `before_iteration` and
`after_iteration` methods respectively that run before/after each iteration.


```pony
trait iso MicroBenchmark
```

## Public Functions

### name
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-19)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### config
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-20)</span>


```pony
fun box config()
: BenchConfig val
```

#### Returns

* [BenchConfig](pony_bench-BenchConfig.md) val

---

### overhead
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-21)</span>


```pony
fun box overhead()
: MicroBenchmark iso^
```

#### Returns

* [MicroBenchmark](pony_bench-MicroBenchmark.md) iso^

---

### before
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-22)</span>


```pony
fun ref before()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### before_iteration
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-23)</span>


```pony
fun ref before_iteration()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### apply
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-24)</span>


```pony
fun ref apply()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### after
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-25)</span>


```pony
fun ref after()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### after_iteration
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-26)</span>


```pony
fun ref after_iteration()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

