/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene912.Lucene912Codec;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCodecFactory
extends CodecFactory
implements SolrCoreAware {
    public static final String COMPRESSION_MODE = "compressionMode";
    public static final Lucene912Codec.Mode SOLR_DEFAULT_COMPRESSION_MODE = Lucene912Codec.Mode.BEST_SPEED;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Codec codec;
    private volatile SolrCore core;

    @Override
    public void inform(SolrCore core) {
        this.core = core;
    }

    @Override
    public void init(NamedList<?> args) {
        Lucene912Codec.Mode compressionMode;
        super.init(args);
        assert (this.codec == null);
        String compressionModeStr = (String)args.get(COMPRESSION_MODE);
        if (compressionModeStr != null) {
            try {
                compressionMode = Lucene912Codec.Mode.valueOf((String)compressionModeStr.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid compressionMode: '" + compressionModeStr + "'. Value must be one of " + Arrays.toString(Lucene912Codec.Mode.values()));
            }
            log.debug("Using compressionMode: {}", (Object)compressionMode);
        } else {
            compressionMode = SOLR_DEFAULT_COMPRESSION_MODE;
            log.debug("Using default compressionMode: {}", (Object)compressionMode);
        }
        this.codec = new Lucene912Codec(compressionMode){

            public PostingsFormat getPostingsFormatForField(String field) {
                String postingsFormatName;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                if (schemaField != null && (postingsFormatName = schemaField.getPostingsFormat()) != null) {
                    return PostingsFormat.forName((String)postingsFormatName);
                }
                return super.getPostingsFormatForField(field);
            }

            public DocValuesFormat getDocValuesFormatForField(String field) {
                String docValuesFormatName;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                if (schemaField != null && (docValuesFormatName = schemaField.getDocValuesFormat()) != null) {
                    return DocValuesFormat.forName((String)docValuesFormatName);
                }
                return super.getDocValuesFormatForField(field);
            }

            public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
                FieldType fieldType;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                FieldType fieldType2 = fieldType = schemaField == null ? null : schemaField.getType();
                if (fieldType instanceof DenseVectorField) {
                    DenseVectorField vectorType = (DenseVectorField)fieldType;
                    String knnAlgorithm = vectorType.getKnnAlgorithm();
                    if ("hnsw".equals(knnAlgorithm)) {
                        int maxConn = vectorType.getHnswMaxConn();
                        int beamWidth = vectorType.getHnswBeamWidth();
                        Lucene99HnswVectorsFormat delegate = new Lucene99HnswVectorsFormat(maxConn, beamWidth);
                        return new SolrDelegatingKnnVectorsFormat((KnnVectorsFormat)delegate, vectorType.getDimension());
                    }
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, knnAlgorithm + " KNN algorithm is not supported");
                }
                return super.getKnnVectorsFormatForField(field);
            }
        };
    }

    @Override
    public Codec getCodec() {
        assert (this.core != null) : "inform must be called first";
        return this.codec;
    }

    private static final class SolrDelegatingKnnVectorsFormat
    extends KnnVectorsFormat {
        private final KnnVectorsFormat delegate;
        private final int maxDimensions;

        public SolrDelegatingKnnVectorsFormat(KnnVectorsFormat delegate, int maxDimensions) {
            super(delegate.getName());
            this.delegate = delegate;
            this.maxDimensions = maxDimensions;
        }

        public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
            return this.delegate.fieldsWriter(state);
        }

        public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
            return this.delegate.fieldsReader(state);
        }

        public int getMaxDimensions(String fieldName) {
            return this.maxDimensions;
        }
    }
}

