/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.ExportBuffers;
import org.apache.solr.handler.export.SortDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWriterStream
extends TupleStream
implements Expressible {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final TupleEntryWriter tupleEntryWriter = new TupleEntryWriter();
    StreamContext context;
    StreamComparator streamComparator;
    int pos = -1;
    int index = -1;
    ExportBuffers exportBuffers;
    ExportBuffers.Buffer buffer;

    public ExportWriterStream(StreamExpression expression, StreamFactory factory) throws IOException {
        this.streamComparator = this.parseComp(factory.getDefaultSort());
    }

    public void setStreamContext(StreamContext context) {
        this.context = context;
    }

    public List<TupleStream> children() {
        return null;
    }

    private StreamComparator parseComp(String sort) throws IOException {
        String[] sorts = sort.split(",");
        StreamComparator[] comps = new StreamComparator[sorts.length];
        for (int i = 0; i < sorts.length; ++i) {
            String s = sorts[i];
            String[] spec = s.trim().split("\\s+");
            if (spec.length != 2) {
                throw new IOException("Invalid sort spec:" + s);
            }
            String fieldName = spec[0].trim();
            String order = spec[1].trim();
            comps[i] = new FieldComparator(fieldName, order.equalsIgnoreCase("asc") ? ComparatorOrder.ASCENDING : ComparatorOrder.DESCENDING);
        }
        if (comps.length > 1) {
            return new MultipleFieldComparator(comps);
        }
        return comps[0];
    }

    public void open() throws IOException {
        this.exportBuffers = (ExportBuffers)this.context.get((Object)"__eb__");
        this.buffer = this.exportBuffers.getOutputBuffer();
    }

    public void close() throws IOException {
        this.exportBuffers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple read() throws IOException {
        Tuple res = null;
        if (this.pos < 0) {
            try {
                this.buffer.outDocsIndex = -1;
                boolean exchanged = false;
                while (!exchanged) {
                    try {
                        long startExchangeBuffers = System.nanoTime();
                        this.exportBuffers.exchangeBuffers();
                        long endExchangeBuffers = System.nanoTime();
                        if (log.isDebugEnabled()) {
                            log.debug("Waited for reader thread:{}", (Object)Long.toString((endExchangeBuffers - startExchangeBuffers) / 1000000L));
                        }
                        exchanged = true;
                    }
                    catch (TimeoutException e) {
                        log.debug("--- ews timeout loop");
                        if (!this.exportBuffers.isShutDown()) continue;
                        log.debug("--- ews - the other end is shutdown, returning EOF");
                        res = Tuple.EOF();
                        break;
                    }
                    catch (InterruptedException e) {
                        log.debug("--- ews interrupted");
                        this.exportBuffers.error(e);
                        res = Tuple.EXCEPTION((Throwable)e, (boolean)true);
                        break;
                    }
                    catch (BrokenBarrierException e) {
                        res = this.exportBuffers.getError() != null ? Tuple.EXCEPTION((Throwable)this.exportBuffers.getError(), (boolean)true) : Tuple.EXCEPTION((Throwable)e, (boolean)true);
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                log.debug("--- ews interrupt");
                this.exportBuffers.error(e);
                res = Tuple.EXCEPTION((Throwable)e, (boolean)true);
            }
            catch (Exception e) {
                log.debug("--- ews exception", (Throwable)e);
                this.exportBuffers.error(e);
                res = Tuple.EXCEPTION((Throwable)e, (boolean)true);
            }
            this.buffer = this.exportBuffers.getOutputBuffer();
            if (this.buffer == null) {
                res = Tuple.EOF();
            }
            if (this.buffer.outDocsIndex == -2) {
                log.debug("--- ews EOF");
                res = Tuple.EOF();
            } else {
                this.pos = this.buffer.outDocsIndex;
                this.index = -1;
                log.debug("--- ews new pos={}", (Object)this.pos);
            }
        }
        if (this.pos < 0) {
            log.debug("--- ews EOF?");
            res = Tuple.EOF();
        }
        if (this.exportBuffers.getError() != null) {
            res = Tuple.EXCEPTION((Throwable)this.exportBuffers.getError(), (boolean)true);
        }
        if (res != null) {
            return res;
        }
        SortDoc sortDoc = this.buffer.outDocs[++this.index];
        this.tupleEntryWriter.tuple = new Tuple();
        this.exportBuffers.exportWriter.writeDoc(sortDoc, this.exportBuffers.leaves, this.tupleEntryWriter, this.exportBuffers.exportWriter.fieldWriters);
        --this.pos;
        return this.tupleEntryWriter.tuple;
    }

    public StreamComparator getStreamSort() {
        return this.streamComparator;
    }

    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(((Object)((Object)this)).getClass()));
        return expression;
    }

    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("input").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-source").withExpression("--non-expressible--");
    }

    private static final class TupleEntryWriter
    implements MapWriter.EntryWriter {
        Tuple tuple;

        private TupleEntryWriter() {
        }

        public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
            if (v instanceof IteratorWriter) {
                ArrayList lst = new ArrayList();
                ((IteratorWriter)v).toList(lst);
                v = lst;
            } else if (v instanceof MapWriter) {
                HashMap map = new HashMap();
                ((MapWriter)v).toMap(map);
                v = map;
            }
            this.tuple.put(k.toString(), (Object)v);
            return this;
        }
    }
}

