/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.TotalHits;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.ByteArrayUtf8CharSequence;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryResponseWriter
implements BinaryQueryResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
        Resolver resolver = new Resolver(req, response.getReturnFields());
        if (req.getParams().getBool("omitHeader", false)) {
            response.removeResponseHeader();
        }
        try (JavaBinCodec jbc = new JavaBinCodec((JavaBinCodec.ObjectResolver)resolver);){
            jbc.setWritableDocFields((JavaBinCodec.WritableDocFields)resolver).marshal(response.getValues(), out);
        }
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        throw new RuntimeException("This is a binary writer , Cannot write to a characterstream");
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/octet-stream";
    }

    public static NamedList<Object> getParsedResponse(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            var out = new ByteArrayOutputStream(){

                ByteArrayInputStream toInputStream() {
                    return new ByteArrayInputStream(this.buf, 0, this.count);
                }
            };
            new BinaryResponseWriter().write(out, req, rsp);
            return new BinaryResponseParser().processResponse((InputStream)out.toInputStream(), null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class MaskCharSeqSolrDocument
    extends SolrDocument {
        MaskCharSeqSolrDocument() {
        }

        public Object getFieldValue(String name) {
            return ByteArrayUtf8CharSequence.convertCharSeq(this._fields.get(name));
        }

        public Collection<Object> getFieldValues(String name) {
            Object v = this._fields.get(name);
            if (v instanceof Collection) {
                return ByteArrayUtf8CharSequence.convertCharSeq((Collection)((Collection)v));
            }
            if (v != null) {
                ArrayList<Object> arr = new ArrayList<Object>(1);
                arr.add(ByteArrayUtf8CharSequence.convertCharSeq(v));
                return arr;
            }
            return null;
        }

        public Collection<Object> getRawFieldValues(String name) {
            Object v = this._fields.get(name);
            if (v instanceof Collection) {
                return (Collection)v;
            }
            if (v != null) {
                ArrayList<Object> arr = new ArrayList<Object>(1);
                arr.add(v);
                return arr;
            }
            return null;
        }

        public Iterator<Map.Entry<String, Object>> iterator() {
            final Iterator it = this._fields.entrySet().iterator();
            return new Iterator<Map.Entry<String, Object>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    return ByteArrayUtf8CharSequence.convertCharSeq((Map.Entry)((Map.Entry)it.next()));
                }
            };
        }

        public Object getFirstValue(String name) {
            Object v = this._fields.get(name);
            if (v == null || !(v instanceof Collection)) {
                return ByteArrayUtf8CharSequence.convertCharSeq(v);
            }
            Collection c = (Collection)v;
            if (c.size() > 0) {
                return ByteArrayUtf8CharSequence.convertCharSeq(c.iterator().next());
            }
            return null;
        }

        public Object get(Object key) {
            return ByteArrayUtf8CharSequence.convertCharSeq(this._fields.get(key));
        }

        public Object getRaw(Object key) {
            return this._fields.get(key);
        }

        public void forEach(Consumer<? super Map.Entry<String, Object>> action) {
            super.forEach(action);
        }
    }

    public static class Resolver
    implements JavaBinCodec.ObjectResolver,
    JavaBinCodec.WritableDocFields {
        protected final SolrQueryRequest solrQueryRequest;
        protected IndexSchema schema;
        protected ReturnFields returnFields;

        public Resolver(SolrQueryRequest req, ReturnFields returnFields) {
            this.solrQueryRequest = req;
            this.returnFields = returnFields;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object resolve(Object o, JavaBinCodec codec) throws IOException {
            if (o instanceof ResultContext) {
                ReturnFields orig = this.returnFields;
                ResultContext res = (ResultContext)o;
                if (res.getReturnFields() != null) {
                    this.returnFields = res.getReturnFields();
                }
                ResultContext.READASBYTES.set(fieldName -> {
                    SchemaField fld = res.getRequest().getSchema().getFieldOrNull((String)fieldName);
                    return fld != null && fld.getType().isUtf8Field();
                });
                try {
                    this.writeResults(res, codec);
                }
                finally {
                    ResultContext.READASBYTES.remove();
                }
                this.returnFields = orig;
                return null;
            }
            if (o instanceof DocList) {
                BasicResultContext ctx = new BasicResultContext((DocList)o, this.returnFields, null, null, this.solrQueryRequest);
                this.writeResults(ctx, codec);
                return null;
            }
            if (o instanceof IndexableField) {
                if (this.schema == null) {
                    this.schema = this.solrQueryRequest.getSchema();
                }
                IndexableField f = (IndexableField)o;
                SchemaField sf = this.schema.getFieldOrNull(f.name());
                try {
                    o = DocsStreamer.getValue(sf, f);
                }
                catch (Exception e) {
                    log.warn("Error reading a field : {}", o, (Object)e);
                }
            }
            return o;
        }

        public boolean isWritable(String name) {
            return this.returnFields.wantsField(name);
        }

        public boolean wantsAllFields() {
            return this.returnFields.wantsAllFields();
        }

        protected void writeResultsBody(ResultContext res, JavaBinCodec codec) throws IOException {
            codec.writeTag((byte)-128, res.getDocList().size());
            Iterator<SolrDocument> docStreamer = res.getProcessedDocuments();
            while (docStreamer.hasNext()) {
                SolrDocument doc = docStreamer.next();
                codec.writeSolrDocument(doc);
            }
        }

        public void writeResults(ResultContext ctx, JavaBinCodec codec) throws IOException {
            codec.writeTag((byte)12);
            ArrayList<Serializable> l = new ArrayList<Serializable>(4);
            l.add(Long.valueOf(ctx.getDocList().matches()));
            l.add(Long.valueOf(ctx.getDocList().offset()));
            Float maxScore = null;
            if (ctx.wantsScores()) {
                maxScore = Float.valueOf(ctx.getDocList().maxScore());
            }
            l.add(maxScore);
            l.add(Boolean.valueOf(ctx.getDocList().hitCountRelation() == TotalHits.Relation.EQUAL_TO));
            codec.writeArray(l);
            this.writeResultsBody(ctx, codec);
        }
    }
}

