/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.attrs;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.carrot2.attrs.AcceptingVisitor;
import org.carrot2.attrs.AliasMapper;
import org.carrot2.attrs.AttrBoolean;
import org.carrot2.attrs.AttrDouble;
import org.carrot2.attrs.AttrEnum;
import org.carrot2.attrs.AttrInteger;
import org.carrot2.attrs.AttrObject;
import org.carrot2.attrs.AttrObjectArray;
import org.carrot2.attrs.AttrString;
import org.carrot2.attrs.AttrStringArray;
import org.carrot2.attrs.AttrVisitor;
import org.carrot2.attrs.ClassNameMapper;
import org.carrot2.internal.nanojson.JsonStringWriter;
import org.carrot2.internal.nanojson.JsonWriter;

public final class Attrs {
    private static final String KEY_WRAPPED = "@value";
    static final String KEY_TYPE = "@type";

    public static Map<String, Object> toMap(AcceptingVisitor composite) {
        return Attrs.toMap(composite, AliasMapper.SPI_DEFAULTS::toName);
    }

    public static Map<String, Object> toMap(AcceptingVisitor composite, Function<Object, String> classToName) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Wrapper<AcceptingVisitor> wrapped = new Wrapper<AcceptingVisitor>(AcceptingVisitor.class, () -> null);
        wrapped.value.set(composite);
        wrapped.accept(new ToMapVisitor(map, classToName));
        Map sub = (Map)map.get(KEY_WRAPPED);
        return sub;
    }

    public static <E extends AcceptingVisitor> E fromMap(Class<? extends E> clazz, Map<String, Object> map) {
        return Attrs.fromMap(clazz, map, AliasMapper.SPI_DEFAULTS::fromName);
    }

    public static <E extends AcceptingVisitor> E fromMap(Class<E> clazz, Map<String, Object> map, Function<String, Object> nameToClass) {
        Wrapper<AcceptingVisitor> wrapper = Attrs.populate(new Wrapper<AcceptingVisitor>(clazz, () -> null), Map.of(KEY_WRAPPED, map), nameToClass);
        return (E)((AcceptingVisitor)Attrs.safeCast(wrapper.value.get(), KEY_WRAPPED, clazz));
    }

    public static <E extends AcceptingVisitor> E fromMap(Class<E> clazz, Supplier<? extends E> defaultImplSupplier, Map<String, Object> map, Function<String, Object> nameToClass) {
        Wrapper<? extends E> wrapper = Attrs.populate(new Wrapper<E>(clazz, defaultImplSupplier), Map.of(KEY_WRAPPED, map), nameToClass);
        return (E)((AcceptingVisitor)Attrs.safeCast(wrapper.value.get(), KEY_WRAPPED, clazz));
    }

    public static <E extends AcceptingVisitor> E fromMap(Class<E> clazz, Supplier<? extends E> defaultImplSupplier, Map<String, Object> map) {
        return Attrs.fromMap(clazz, defaultImplSupplier, map, AliasMapper.SPI_DEFAULTS::fromName);
    }

    public static Map<String, Object> extract(AcceptingVisitor instance, Function<Object, String> classToName) {
        Map<String, Object> attrs = Attrs.toMap(instance, classToName);
        attrs.remove(KEY_TYPE);
        return attrs;
    }

    public static Map<String, Object> extract(AcceptingVisitor instance) {
        return Attrs.extract(instance, AliasMapper.SPI_DEFAULTS::toName);
    }

    public static <E extends AcceptingVisitor> E populate(E instance, Map<String, Object> map) {
        return Attrs.populate(instance, map, AliasMapper.SPI_DEFAULTS::fromName);
    }

    public static <E extends AcceptingVisitor> E populate(E instance, Map<String, Object> map, Function<String, Object> nameToClass) {
        FromMapVisitor visitor = new FromMapVisitor(map, nameToClass);
        instance.accept(visitor);
        visitor.ensureKeysConsumed();
        return instance;
    }

    public static String toJson(AcceptingVisitor composite) {
        return Attrs.toJson(composite, AliasMapper.SPI_DEFAULTS);
    }

    public static String toJson(AcceptingVisitor composite, ClassNameMapper classNameMapper) {
        return Attrs.toJson(composite, classNameMapper::toName);
    }

    public static String toJson(AcceptingVisitor composite, Function<Object, String> classToName) {
        Map<String, Object> asMap = Attrs.toMap(composite, classToName);
        return ((JsonStringWriter)JsonWriter.indent("  ").string().object((Map)asMap)).done();
    }

    static <T> T safeCast(Object value, String key, Class<T> clazz) {
        if (value == null) {
            return null;
        }
        if (!clazz.isInstance(value)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Value at key '%s' should be an instance of '%s', but encountered class '%s': '%s'", key, clazz.getSimpleName(), value.getClass().getSimpleName(), Attrs.toDebugString(value)));
        }
        return clazz.cast(value);
    }

    static String toDebugString(Object value) {
        if (value == null) {
            return "[null]";
        }
        if (value instanceof Object[]) {
            return Arrays.deepToString((Object[])value);
        }
        return Objects.toString(value);
    }

    private static class ToMapVisitor
    implements AttrVisitor {
        private final Map<String, Object> map;
        private final Function<Object, String> objectToClass;

        public ToMapVisitor(Map<String, Object> map, Function<Object, String> objectToClass) {
            this.map = map;
            this.objectToClass = objectToClass;
        }

        @Override
        public void visit(String key, AttrInteger attr) {
            this.ensureNoExistingKey(this.map, key);
            this.map.put(key, attr.get());
        }

        @Override
        public void visit(String key, AttrDouble attr) {
            this.ensureNoExistingKey(this.map, key);
            this.map.put(key, attr.get());
        }

        @Override
        public void visit(String key, AttrBoolean attr) {
            this.ensureNoExistingKey(this.map, key);
            this.map.put(key, attr.get());
        }

        @Override
        public <T extends AcceptingVisitor> void visit(String key, AttrObject<T> attr) {
            this.ensureNoExistingKey(this.map, key);
            Object currentValue = attr.get();
            if (currentValue != null) {
                LinkedHashMap<String, Object> submap = new LinkedHashMap<String, Object>();
                if (!attr.isDefaultClass(currentValue)) {
                    submap.put(Attrs.KEY_TYPE, this.objectToClass.apply(currentValue));
                }
                currentValue.accept(new ToMapVisitor(submap, this.objectToClass));
                this.map.put(key, submap);
            } else {
                this.map.put(key, null);
            }
        }

        @Override
        public <T extends AcceptingVisitor> void visit(String key, AttrObjectArray<T> attr) {
            this.ensureNoExistingKey(this.map, key);
            Object values = attr.get();
            if (values != null) {
                Object[] array = values.stream().map(currentValue -> {
                    LinkedHashMap<String, Object> submap = new LinkedHashMap<String, Object>();
                    if (!attr.isDefaultClass(currentValue)) {
                        submap.put(Attrs.KEY_TYPE, this.objectToClass.apply(currentValue));
                    }
                    currentValue.accept(new ToMapVisitor(submap, this.objectToClass));
                    return submap;
                }).toArray();
                this.map.put(key, array);
            } else {
                this.map.put(key, null);
            }
        }

        @Override
        public <T extends Enum<T>> void visit(String key, AttrEnum<T> attr) {
            this.ensureNoExistingKey(this.map, key);
            this.map.put(key, attr.get() != null ? ((Enum)attr.get()).name() : null);
        }

        @Override
        public void visit(String key, AttrStringArray attr) {
            this.ensureNoExistingKey(this.map, key);
            this.map.put(key, attr.get());
        }

        @Override
        public void visit(String key, AttrString attr) {
            this.ensureNoExistingKey(this.map, key);
            this.map.put(key, attr.get());
        }

        private void ensureNoExistingKey(Map<?, ?> map, String key) {
            if (map.containsKey(key)) {
                throw new RuntimeException(String.format(Locale.ROOT, "Could not serialize key '%s' because it already exists in the map with value: %s", key, map.get(key)));
            }
        }
    }

    private static class FromMapVisitor
    implements AttrVisitor {
        private final Map<String, Object> map;
        private final Function<String, Object> classToInstance;

        private FromMapVisitor(Map<String, Object> map, Function<String, Object> classToInstance) {
            this.map = new LinkedHashMap<String, Object>(Objects.requireNonNull(map));
            this.classToInstance = classToInstance;
        }

        @Override
        public void visit(String key, AttrInteger attr) {
            if (this.map.containsKey(key)) {
                Number value = Attrs.safeCast(this.map.remove(key), key, Number.class);
                if (value != null) {
                    if (Double.compare(value.doubleValue(), value.longValue()) != 0) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Value at key '%s' should be an integer but encountered floating point value: '%s'", key, Attrs.toDebugString(value)));
                    }
                    long v = value.longValue();
                    if ((long)((int)v) != v) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Value at key '%s' should be an integer but is out of integer range: '%s'", key, Attrs.toDebugString(value)));
                    }
                    attr.set((int)v);
                } else {
                    attr.set(null);
                }
            }
        }

        @Override
        public void visit(String key, AttrDouble attr) {
            if (this.map.containsKey(key)) {
                Number value = Attrs.safeCast(this.map.remove(key), key, Number.class);
                attr.set(value == null ? null : Double.valueOf(value.doubleValue()));
            }
        }

        @Override
        public void visit(String key, AttrBoolean attr) {
            if (this.map.containsKey(key)) {
                attr.set(Attrs.safeCast(this.map.remove(key), key, Boolean.class));
            }
        }

        @Override
        public <T extends AcceptingVisitor> void visit(String key, AttrObject<T> attr) {
            if (this.map.containsKey(key)) {
                LinkedHashMap<String, Object> submap = Attrs.safeCast(this.map.remove(key), key, Map.class);
                if (submap == null) {
                    attr.set((Object)null);
                } else {
                    AcceptingVisitor value;
                    if ((submap = new LinkedHashMap<String, Object>(submap)).containsKey(Attrs.KEY_TYPE)) {
                        String valueType = Attrs.safeCast(submap.remove(Attrs.KEY_TYPE), Attrs.KEY_TYPE, String.class);
                        value = (AcceptingVisitor)Attrs.safeCast(this.classToInstance.apply(valueType), key, attr.getInterfaceClass());
                    } else {
                        value = (AcceptingVisitor)this.notNull(key, attr.newDefaultValue());
                    }
                    FromMapVisitor visitor = new FromMapVisitor(submap, this.classToInstance);
                    value.accept(visitor);
                    visitor.ensureKeysConsumed();
                    attr.set((Object)value);
                }
            }
        }

        @Override
        public <T extends AcceptingVisitor> void visit(String key, AttrObjectArray<T> attr) {
            if (this.map.containsKey(key)) {
                Object value = this.map.remove(key);
                if (value == null) {
                    attr.set(null);
                } else {
                    List<Object> array;
                    if (value instanceof List) {
                        array = (List<Object>)value;
                    } else if (value instanceof Object[]) {
                        array = Arrays.asList((Object[])value);
                    } else {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Value at key '%s' should be a list or an array of objects of type '%s' but is an instance of '%s': '%s'", key, attr.getInterfaceClass().getSimpleName(), value.getClass().getSimpleName(), Attrs.toDebugString(value)));
                    }
                    List entries = array.stream().map(entry -> {
                        AcceptingVisitor entryValue;
                        LinkedHashMap<String, Object> submap = Attrs.safeCast(entry, key, Map.class);
                        if (submap == null) {
                            return null;
                        }
                        if ((submap = new LinkedHashMap<String, Object>(submap)).containsKey(Attrs.KEY_TYPE)) {
                            String entryValueType = Attrs.safeCast(submap.remove(Attrs.KEY_TYPE), Attrs.KEY_TYPE, String.class);
                            entryValue = (AcceptingVisitor)Attrs.safeCast(this.classToInstance.apply(entryValueType), key, attr.getInterfaceClass());
                        } else {
                            entryValue = (AcceptingVisitor)this.notNull(key, attr.newDefaultEntryValue());
                        }
                        FromMapVisitor visitor = new FromMapVisitor(submap, this.classToInstance);
                        entryValue.accept(visitor);
                        visitor.ensureKeysConsumed();
                        return entryValue;
                    }).collect(Collectors.toList());
                    attr.set(entries);
                }
            }
        }

        @Override
        public <T extends Enum<T>> void visit(String key, AttrEnum<T> attr) {
            if (this.map.containsKey(key)) {
                Object value = this.map.remove(key);
                if (value == null) {
                    attr.set(null);
                } else if (value instanceof String) {
                    try {
                        attr.set((Enum)Enum.valueOf(attr.enumClass(), (String)value));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Value at key '%s' should be an enum constant of class '%s', but no such constant exists: '%s' (available constants: %s)", key, attr.enumClass().getSimpleName(), Attrs.toDebugString(value), EnumSet.allOf(attr.enumClass())));
                    }
                } else {
                    attr.set((Enum)Attrs.safeCast(value, key, attr.enumClass()));
                }
            }
        }

        @Override
        public void visit(String key, AttrStringArray attr) {
            if (this.map.containsKey(key)) {
                Object value = this.map.remove(key);
                if (value instanceof Object[]) {
                    attr.set((String[])Stream.of((Object[])value).map(ob -> Attrs.safeCast(ob, key, String.class)).toArray(String[]::new));
                } else if (value instanceof List) {
                    attr.set((String[])((List)value).stream().map(ob -> Attrs.safeCast(ob, key, String.class)).toArray(String[]::new));
                } else {
                    attr.set(Attrs.safeCast(value, key, String[].class));
                }
            }
        }

        @Override
        public void visit(String key, AttrString attr) {
            if (this.map.containsKey(key)) {
                attr.set(Attrs.safeCast(this.map.remove(key), key, String.class));
            }
        }

        private <T> T notNull(String key, T value) {
            if (value == null) {
                throw new RuntimeException(String.format(Locale.ROOT, "Default attribute implementation supplier returned null for key: '%s'", key));
            }
            return value;
        }

        public void ensureKeysConsumed() {
            if (!this.map.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Unrecognized extra attributes with keys: %s", String.join((CharSequence)", ", this.map.keySet())));
            }
        }
    }

    private static class Wrapper<E extends AcceptingVisitor>
    implements AcceptingVisitor {
        final AttrObject<E> value;

        public Wrapper(Class<E> clazz, Supplier<? extends E> defaultInstanceSupplier) {
            this.value = AttrObject.builder(clazz).defaultValue(defaultInstanceSupplier);
        }

        @Override
        public void accept(AttrVisitor visitor) {
            visitor.visit(Attrs.KEY_WRAPPED, this.value);
        }
    }
}

