/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class AssignmentChangeEvent
extends ApplicationEvent {
    private final Map<TopicPartition, OffsetAndMetadata> offsets;
    private final long currentTimeMs;

    public AssignmentChangeEvent(Map<TopicPartition, OffsetAndMetadata> offsets, long currentTimeMs) {
        super(ApplicationEvent.Type.ASSIGNMENT_CHANGE);
        this.offsets = Collections.unmodifiableMap(offsets);
        this.currentTimeMs = currentTimeMs;
    }

    public Map<TopicPartition, OffsetAndMetadata> offsets() {
        return this.offsets;
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", offsets=" + this.offsets + ", currentTimeMs=" + this.currentTimeMs;
    }
}

