/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import java.io.IOException;

public class NewAcronymStyle
extends AbstractGlsCommand {
    protected Overwrite overwrite;

    public NewAcronymStyle(GlossariesSty glossariesSty) {
        this("newacronymstyle", Overwrite.FORBID, glossariesSty);
    }

    public NewAcronymStyle(String string, Overwrite overwrite, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.overwrite = overwrite;
    }

    @Override
    public Object clone() {
        return new NewAcronymStyle(this.getName(), this.getOverwrite(), this.getSty());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string = this.popLabelString(teXParser, teXObjectList);
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        TeXObject teXObject2 = this.popArg(teXParser, teXObjectList);
        ControlSequence controlSequence = teXParser.getControlSequence("@glsacr@dispstyle@" + string);
        if (controlSequence != null) {
            switch (this.overwrite) {
                case SKIP: {
                    return;
                }
                case FORBID: {
                    throw new LaTeXSyntaxException(teXParser, "glossaries.acronym.style.defined", string);
                }
            }
        }
        teXParser.putControlSequence(true, new GenericCommand(true, "@glsacr@dispstyle@" + string, null, teXObject));
        teXParser.putControlSequence(true, new GenericCommand(true, "@glsacr@styledefs@" + string, null, teXObject2));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public Overwrite getOverwrite() {
        return this.overwrite;
    }
}

