﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ecs/ECS_EXPORTS.h>

namespace Aws {
namespace ECS {
namespace Model {
enum class PlatformDeviceType { NOT_SET, GPU };

namespace PlatformDeviceTypeMapper {
AWS_ECS_API PlatformDeviceType GetPlatformDeviceTypeForName(const Aws::String& name);

AWS_ECS_API Aws::String GetNameForPlatformDeviceType(PlatformDeviceType value);
}  // namespace PlatformDeviceTypeMapper
}  // namespace Model
}  // namespace ECS
}  // namespace Aws
