<xsl:transform version="1.0" 
	       xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="common.xsl"/>
<xsl:variable name="base-locale">..</xsl:variable>
  <xsl:variable name="ctandist">
    <xsl:value-of select="entry/distribution/ctan"/>
  </xsl:variable>
  <xsl:variable name="texlivedist">
    <xsl:value-of select="entry/distribution/texlive"/>
  </xsl:variable>
  <xsl:variable name="homepage">
    <xsl:value-of select="entry/about/home"/>
  </xsl:variable>

<!-- PROCESS THE ENTRY -->

<xsl:template match="entry">
  <!-- Had to record the datestamp as a variable since I could not get
       the @datestamp value after processing any children templates? -->
  <xsl:variable name="datestamp">
    <xsl:value-of select="@datestamp"/>
  </xsl:variable>
  <xsl:comment>
    This file is automatically generated. Do not edit!
  </xsl:comment>
  <HTML>
    <xsl:call-template name="header"/>
    <BODY>
      <xsl:call-template name="title"/>
      <TABLE CELLPADDING="3" WIDTH="100%">
        <!-- HEADING -->
        <TR>
          <TH ALIGN="left" VALIGN="top" ROWSPAN="4" WIDTH="20%">
            <BIG>
              <A NAME="{@id}">
                <xsl:if test="about/name">
                  <xsl:apply-templates select="about/name"/>
                </xsl:if>
              </A>
            </BIG>
          </TH>
          <!-- CAPTION -->
          <TD ALIGN="left" VALIGN="bottom" COLSPAN="2" WIDTH="80%">
            <STRONG>
              <EM>
                <xsl:value-of select="about/caption"/>
              </EM>
            </STRONG>
          </TD>
        </TR>
        <!-- ABSTRACT -->
  <TR>
    <TD COLSPAN="2" WIDTH="80%">
      <P class="notes">
      <xsl:if test="description/abstract">
        <xsl:apply-templates select="description/abstract"/>
      </xsl:if>
      <xsl:if test="about/author/name">
	<xsl:text> This package was implemented by </xsl:text>
        <xsl:apply-templates select="about/author"/>
	<xsl:text> catalogued for </xsl:text><A HREF="http://www.ctan.org">CTAN</A>
	<xsl:text>.</xsl:text>
      </xsl:if>
      <xsl:if test="about/xref">
        <xsl:text> See also</xsl:text>
          <xsl:apply-templates select="about/xref"/>
      </xsl:if>
      </P>
    </TD>
  </TR>

  <!-- BUTTONS -->
  <TR>
  <xsl:call-template name="buttons"/>

  <TD ALIGN="right" valign="bottom" WIDTH="50%">
    <SMALL>
      <EM>
        <xsl:text>License: </xsl:text>
        <STRONG>
          <xsl:apply-templates select="about/license"/>
        </STRONG>
         <xsl:if test="about/version/number">
           <xsl:apply-templates select="about/version/number"/>
         </xsl:if>
         <!--xsl:choose>
         <xsl:when test="about/version/released">
           <xsl:apply-templates select="about/version/released"/>
         </xsl:when>
         <xsl:otherwise-->
            <xsl:text> Catalogued: </xsl:text>
            <STRONG><xsl:value-of select="$datestamp"/></STRONG>
         <!--/xsl:otherwise>
         </xsl:choose-->
      </EM>
    </SMALL>
  </TD>
  </TR>
  <TR><TD COLSPAN="2" WIDTH="80%" VALIGN="top" HEIGHT="1"></TD></TR>
</TABLE>
<HR/>
      <xsl:call-template name="author"/>
</BODY>

</HTML>

</xsl:template>

<xsl:template match="about/license">
  <xsl:choose>
    <xsl:when test="@type">
      <A HREF="../licenses.{@type}.html">
        <xsl:value-of select="@type"/>
      </A>
    </xsl:when>
    <xsl:otherwise>
      <A HREF="../licenses.unknown.html">unknown</A>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="about/author">
  <xsl:if test="name='unknown'">
    <xsl:text>an author </xsl:text>
  </xsl:if>
  <xsl:if test="name">
    <xsl:apply-templates select="name"/><xsl:text> and </xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template match="about/xref">
  <xsl:text> </xsl:text>
  <A HREF="{@refid}.html"> <xsl:value-of select="@refid"/></A>
</xsl:template>

<xsl:template match="xref">
  <A HREF="{@refid}.html"> <xsl:apply-templates/></A>
</xsl:template>

</xsl:transform>


