

proc alpha::startup {} {
    global mode::features mode 
    variable adjust_mode $mode
    eval tk_optionMenu .status.mode ::alpha::adjust_mode [lsort [array names mode::features]]
    .status.mode configure -indicatoron 0
    trace variable ::alpha::adjust_mode w alpha::adjust_mode
    displayMode $mode
    
    generalBasicBindings
}

proc alpha::adjust_mode {name args} {
    global mode
    variable adjust_mode
    #echo "$mode $adjust_mode"
    if {$mode != $adjust_mode} {
	newMode $adjust_mode
    }
}

proc alpha::filesMenu {w} {
    $w delete 0 end
    global multiColumnMenusEveryNItems
    set count [expr {1 + $multiColumnMenusEveryNItems}]
    foreach m [::optClickTB_List] {
	incr count -1
	if {$m == "(-" || $m == "-"} {
	    $w add separator
	} else {
	    $w add command -label $m -command [list optClickTB_Pick $m]
	}
	if {$count < 0} {
	    $w entryconfigure $m -columnbreak 1
	    set count $multiColumnMenusEveryNItems
	}
    }
    
}

proc alpha::parseFuncs {w} {
    variable funcs
    if {[info exists funcs([win::Current])]} {
	return 
    } else {
	global multiColumnMenusEveryNItems
	set count [expr {1 + $multiColumnMenusEveryNItems}]
	foreach {m p} [::parseFuncsAlpha] {
	    incr count -1
	    if {$m == "(-" || $m == "-"} {
		$w add separator
	    } else {
		$w add command -label $m -command [list goto $p]
	    }
	    if {$count < 0} {
		$w entryconfigure $m -columnbreak 1
		set count $multiColumnMenusEveryNItems
	    }
	}
	set funcs([win::Current]) 1
    }
}

proc alpha::markMenuClear {w} {
    variable marks
    catch {unset marks([win::Current])}
    catch {destroy $w}
    ::menu $w -tearoff 0 \
      -postcommand [list alpha::markFile $w]
    $w add command -label "Mark File" \
      -command "alpha::markMenuClear $w ; markFile"
    $w add separator

}

proc alpha::convertChars {str} {
    regsub -all  $str "..." str
    regsub -all "" $str "->" str
    return $str
}

proc alpha::markFile {w} {
    variable marks
    if {[info exists marks([win::Current])]} {
	return 
    } else {
	if {[llength [set themarks [::getNamedMarks [win::Current]]]] != 0} {
	    global multiColumnMenusEveryNItems
	    set count [expr {1 + $multiColumnMenusEveryNItems}]
	    foreach m $themarks {
		incr count -1
		$w add command -label [convertChars [lindex $m 0]] \
		  -command "[list goto [lindex $m 2]] ; select [lrange $m 3 4]"
		if {$count < 0} {
		    $w entryconfigure [lindex $m 0] -columnbreak 1
		    set count $multiColumnMenusEveryNItems
		}
	    }
	    set marks([win::Current]) 1
	}
    }
}


proc alpha::generalBasicBindings {} {
    Bind Left <c> beginningOfLine
    Bind Left <s> backwardCharSelect
    Bind Left <sc> beginningLineSelect
    Bind Left <z> {scrollLeftCol 15}
    Bind Left <o> backwardWord
    Bind Left <os> backwardWordSelect
    
    Bind Right <c> endOfLine
    Bind Right <s> forwardCharSelect
    Bind Right <sc> endLineSelect
    Bind Right <z> {scrollRightCol 15}
    Bind Right <o> forwardWord
    Bind Right <os> forwardWordSelect
    
    Bind Up <s>    prevLineSelect
    Bind Up <c>    beginningOfBuffer
    Bind Up <sc>   beginningBufferSelect
    Bind Up <z>    scrollUpLine
    Bind Up <o>    scrollUpLine
    
    Bind Down <c>  endOfBuffer
    Bind Down <s>  nextLineSelect
    Bind Down <sc> endBufferSelect
    Bind Down <z>  scrollDownLine
    Bind Down <o>  scrollDownLine
}






