
proc wrapJava {dir} {
    set fout [open WrapPlugin.java w]
    puts $fout "public class WrapPlugin implements tcl.lang.TclClassPlugin \{\npublic WrapPlugin() \{\}\n\n"
    
    foreach f [glob -nocomplain [file join $dir *.class]] {
	set r [file tail [file root $f]]
	set rp [join [file split [file root $f]] .]
	puts $fout "byte\[\] make$r () \{"
	puts $fout "byte \[\] $r = \{[join [fileToJavaByteArray $f] ,\n]\};"
	puts $fout "return $r ;"
	puts $fout "\}"
	append ex "if (className.equals(\"$rp\")) \{\n"
	append ex "    classData = make$r ();\n"
	append ex "\} else "
    }
    puts $fout "\npublic byte\[\] getClassData(String className) \{\n    byte  classData\[\];\n"
    append ex "\{\n    classData = null;\n\}\nreturn classData;\n\}"
    puts $fout $ex
    puts $fout "\}"
    close $fout
}

proc fileToJavaByteArray {f} {
    set file [open $f r]
    fconfigure $file -translation binary -encoding binary
    set data [read $file]       
    close $file
    set out {}
    foreach i [split $data ""] {
	scan $i "%c" v
	lappend out "(byte)$v"
    }
    return $out
}

wrapJava bios

