package require Cpptcl

proc cpp::completion {commandLine} {
	set comp [eval cpptcl complete $commandLine]
	switch [lindex $comp 0] {
		"Completions:" {
			set common [cpptcl maxCompletion]
			if { $common != "" } {
				return [list $common ""]
				return ""
			} else {
				beep
				return [list "" $comp]
			}
		}
		"No" {
			beep
			return ""
		}
		"Already" {
			beep
			return ""
		}
	}
}

proc cpp::documentObject {obj} {
	set cmds [lrange [split [cpptcl complete $obj] "\n"] 1 end]
	set doc {}
	foreach f $cmds {
		catch {eval $f -h} d
		append doc "${d}\n"
	}
	return $doc
}

proc cpp::visualHierarchy {} {
	return [_visualHierarchy [cppmeta listDescendants]]
}

proc cpp::_visualHierarchy {hier {indent {}}} {
	set res ""
	foreach h $hier {
		append res "${indent}[lindex $h 0]\n"
		if {[llength $h] > 1} {
			append res [_visualHierarchy [lindex $h 1] "  $indent"]
		}
	}
	return $res
}
