/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *                 Jehan <jehan@girinstud.io>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSBCharSetProber.h"

/********* Language model for: Vietnamese *********/

/**
 * Generated by BuildLangModel.py
 * On: 2016-05-04 11:20:12.980501
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static unsigned char VisciiCharToOrderMap[] =
{
  CTR,CTR, 88,CTR,CTR, 91, 77,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR, 80,CTR,CTR,CTR,CTR, 81,CTR,CTR,CTR,CTR, 94,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  6, 17,  3, 22, 21, 66,  5,  1,  4, 74, 24, 14,  9,  0,  8, /* 4X */
   16, 34, 11, 19,  2,  7, 13, 70, 54, 20, 83,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  6, 17,  3, 22, 21, 66,  5,  1,  4, 74, 24, 14,  9,  0,  8, /* 6X */
   16, 34, 11, 19,  2,  7, 13, 70, 54, 20, 83,SYM,SYM,SYM,SYM,CTR, /* 7X */
   31, 57, 68, 64, 41, 42, 78, 51, 82, 89, 23, 46, 38, 75, 28, 30, /* 8X */
   52, 63, 84, 33, 37, 40, 39, 59, 43, 79, 44, 73, 36, 71, 45, 76, /* 9X */
   86, 57, 68, 64, 41, 42, 78, 51, 82, 89, 23, 46, 38, 75, 28, 30, /* AX */
   52, 63, 84, 90, 47, 33, 39, 59, 43, 56, 55, 53, 72, 47, 40, 18, /* BX */
   12, 15, 26, 60, 35, 50, 88, 91, 87, 61, 27, 85, 49, 48, 65, 76, /* CX */
   10, 55, 62, 32, 29, 31, 80, 53, 72, 58, 69, 81, 94, 67, 90, 18, /* DX */
   12, 15, 26, 60, 35, 50, 25, 77, 87, 61, 27, 85, 49, 48, 65, 73, /* EX */
   10, 56, 62, 32, 29, 86, 79, 44, 45, 58, 69, 71, 36, 67, 37, 25, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static unsigned char Windows1258CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  6, 17,  3, 22, 21, 66,  5,  1,  4, 74, 24, 14,  9,  0,  8, /* 4X */
   16, 34, 11, 19,  2,  7, 13, 70, 54, 20, 83,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  6, 17,  3, 22, 21, 66,  5,  1,  4, 74, 24, 14,  9,  0,  8, /* 6X */
   16, 34, 11, 19,  2,  7, 13, 70, 54, 20, 83,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,104,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,101,ILL,ILL,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,101,ILL,ILL,105, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,106,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   12, 15, 26, 50, 98,107, 99, 92, 87, 61, 27,108,SYM, 48,102,103, /* CX */
   10, 97,SYM, 32, 29, 47, 95,SYM, 93, 58, 69,109, 96, 18,SYM,100, /* DX */
   12, 15, 26, 50, 98,110, 99, 92, 87, 61, 27,111,SYM, 48,102,103, /* EX */
   10, 97,SYM, 32, 29, 47, 95,SYM, 93, 58, 69,112, 96, 18,113,114, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1522
 * First 512 sequences: 0.9339706640423637
 * Next 512 sequences (512-1024): 0.05899474618721069
 * Rest: 0.007034589770425578
 * Negative sequences: TODO
 */
static char VietnameseLangModel[] =
{
  3,3,3,3,3,3,3,3,3,1,0,2,3,1,1,1,1,2,3,3,2,3,3,3,2,2,1,
   3,0,3,2,2,3,2,1,1,0,1,0,2,0,1,1,0,0,0,2,3,1,0,3,0,0,0,2,
  2,1,2,0,3,0,3,3,3,2,0,2,3,0,1,3,1,0,3,1,3,3,2,3,1,3,3,
   3,3,3,3,3,3,3,0,3,3,3,3,3,2,3,3,3,3,3,1,3,3,3,2,3,2,2,0,
  2,3,2,2,3,1,3,3,3,1,0,3,3,2,2,3,2,0,3,2,2,3,1,3,0,0,3,
   3,1,3,3,3,2,3,0,3,2,0,1,2,2,3,2,2,0,2,0,1,3,2,2,2,2,3,0,
  2,3,3,2,3,0,3,3,3,2,0,2,2,1,2,3,1,1,2,2,2,3,1,0,2,0,3,
   0,0,3,2,2,3,3,1,3,3,1,0,2,0,3,3,0,0,2,0,3,0,0,2,2,1,1,1,
  3,1,3,3,3,3,3,2,3,3,1,3,2,2,3,3,2,2,0,3,1,3,3,3,2,3,1,
   3,3,2,3,0,1,0,2,3,0,0,3,2,3,2,0,0,2,0,3,0,0,0,1,1,0,0,2,
  2,3,2,2,3,1,3,3,3,1,0,3,3,0,2,2,0,1,3,2,2,3,1,1,1,3,2,
   0,0,3,2,2,2,1,0,1,1,2,0,2,0,1,3,1,3,1,0,0,0,2,1,1,3,1,0,
  3,2,3,3,3,2,1,3,3,3,0,3,0,2,3,0,2,3,0,3,3,2,3,0,2,0,0,
   0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,2,
  3,1,3,2,3,2,3,1,2,3,0,3,2,2,3,2,2,2,0,3,3,3,2,2,1,0,3,
   2,1,3,3,1,0,3,0,2,0,0,0,1,1,3,2,0,0,0,0,2,2,0,2,3,3,0,1,
  3,2,3,3,3,2,3,3,2,3,0,3,3,2,3,3,2,2,0,3,2,2,3,0,2,0,0,
   0,0,0,0,3,1,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,
  2,1,0,2,3,0,3,2,3,2,0,1,3,0,2,3,2,2,3,2,2,3,2,0,0,0,2,
   0,2,2,2,3,2,3,0,1,0,0,0,2,3,3,1,0,2,3,2,0,0,2,1,2,1,2,1,
  0,0,0,0,3,0,3,2,3,0,0,1,3,0,0,3,0,0,3,0,0,1,0,3,0,0,3,
   2,3,3,3,3,3,3,0,3,2,1,3,2,1,3,3,3,3,0,3,3,2,2,1,1,3,0,0,
  3,2,3,2,3,2,3,3,3,2,0,3,2,2,3,3,1,2,3,3,3,3,3,0,2,2,1,
   3,1,2,2,2,0,3,0,2,0,2,1,2,0,3,2,3,3,2,0,1,2,3,2,2,2,2,0,
  3,0,0,0,3,0,0,2,3,3,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,3,0,3,3,2,0,0,1,3,0,1,1,0,0,2,1,1,3,1,1,0,1,2,
   2,1,2,1,1,0,0,0,0,0,1,0,1,3,2,3,3,1,3,3,0,3,3,3,3,0,2,0,
  0,2,2,1,3,2,3,3,3,2,0,0,3,2,3,2,2,2,3,2,2,3,2,1,1,1,2,
   3,3,2,2,3,1,3,0,0,0,2,0,2,3,2,3,3,0,2,0,1,2,0,2,3,0,0,1,
  3,0,3,3,3,1,0,2,3,3,0,1,0,0,1,0,3,0,0,1,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,2,0,3,0,3,2,3,1,0,3,0,0,2,0,2,1,0,2,2,3,1,0,0,0,0,
   2,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  2,1,0,3,3,0,3,3,3,0,0,3,2,0,3,3,0,3,1,2,2,3,1,1,0,0,1,
   2,1,0,3,2,2,3,0,3,0,0,0,1,2,2,2,3,0,1,1,0,2,2,0,2,3,1,0,
  3,0,1,1,2,0,3,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,3,0,3,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
  1,3,3,3,3,1,3,3,3,2,0,1,2,1,2,3,2,2,2,3,2,3,2,0,2,0,2,
   1,0,2,3,0,2,0,1,2,0,1,1,1,1,1,0,0,0,1,0,2,0,0,0,0,1,0,0,
  2,0,1,2,1,0,2,2,2,1,0,2,0,0,1,1,2,1,0,2,0,2,1,3,1,0,0,
   3,2,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,
  3,1,3,3,2,2,3,2,3,3,0,3,0,2,3,1,2,2,0,3,2,2,3,0,2,0,0,
   0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
  1,1,1,2,3,2,3,3,3,0,0,3,3,0,2,1,0,0,3,2,2,3,2,0,1,1,3,
   1,0,0,1,3,1,1,0,0,0,0,0,1,0,3,2,3,1,3,0,0,1,1,1,2,1,1,0,
  3,0,3,1,0,0,0,3,0,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,3,1,0,3,1,3,2,2,0,0,2,0,1,2,0,0,1,0,2,2,2,0,3,1,0,0,
   2,0,1,0,0,0,0,0,0,0,0,2,0,0,0,0,2,0,0,0,0,2,2,0,0,0,0,1,
  3,0,0,0,0,0,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,2,0,0,0,3,0,3,0,0,0,0,1,0,1,0,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,1,0,0,0,3,0,3,1,1,0,0,0,0,1,0,0,2,0,0,0,0,0,0,0,
   0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,0,3,3,0,0,0,3,0,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,2,3,1,0,0,0,3,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
   0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,0,3,2,0,0,0,0,0,0,3,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,2,3,0,3,0,0,2,0,1,0,1,0,0,2,0,0,0,0,0,0,0,1,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,3,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,0,3,2,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,3,2,0,0,2,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,3,3,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,0,0,0,0,3,0,3,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,1,0,0,3,0,2,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,3,0,0,3,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,3,3,0,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,3,1,0,0,0,0,1,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,1,3,0,0,2,0,2,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,3,0,0,2,1,0,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,1,1,0,0,0,0,3,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,1,0,0,0,2,0,2,0,0,0,0,0,0,3,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,2,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,2,1,2,0,3,3,2,1,0,0,0,2,0,2,1,0,2,0,1,3,0,2,0,0,2,
   2,0,2,0,1,1,1,0,2,0,0,0,1,0,1,0,0,0,0,0,1,2,1,1,0,0,0,2,
};


SequenceModel Viscii_VietnameseModel =
{
  VisciiCharToOrderMap,
  VietnameseLangModel,
  55,
  (float)0.9339706640423637,
  PR_FALSE,
  "VISCII"
};

SequenceModel Windows1258_VietnameseModel =
{
  Windows1258CharToOrderMap,
  VietnameseLangModel,
  55,
  (float)0.9339706640423637,
  PR_FALSE,
  "windows-1258"
};
