/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.util.dnd.TransferDataSelectionOfFb;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;

public abstract class FbTypeTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    AutomationSystem system;

    public FbTypeTemplateTransferDropTargetListener(EditPartViewer viewer, AutomationSystem system) {
        super(viewer);
        this.system = system;
    }

    protected void handleDragOver() {
        super.handleDragOver();
        this.getCurrentEvent().feedback = 24;
        if (TemplateTransfer.getInstance().getTemplate() == null) {
            this.getCurrentEvent().detail = 0;
            this.getCurrentEvent().operations = 0;
        } else if (TemplateTransfer.getInstance().getTemplate() instanceof FBTypePaletteEntry) {
            FBTypePaletteEntry entry = (FBTypePaletteEntry)TemplateTransfer.getInstance().getTemplate();
            AutomationSystem paletteSystem = entry.getGroup().getPallete().getAutomationSystem();
            if (paletteSystem == null && this.system == null || paletteSystem != null && this.system != null && this.system.equals(paletteSystem)) {
                this.getCurrentEvent().detail = 1;
            } else {
                this.getCurrentEvent().detail = 0;
                this.getCurrentEvent().operations = 0;
            }
        }
    }

    protected void handleDrop() {
        if (!(this.getCurrentEvent().data instanceof FBTypePaletteEntry || this.getCurrentEvent().data instanceof SubApplicationTypePaletteEntry || this.getCurrentEvent().data instanceof TransferDataSelectionOfFb[])) {
            return;
        }
        super.handleDrop();
        TemplateTransfer.getInstance().setTemplate(null);
    }
}

