/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.List;
import org.eclipse.fordiac.ide.application.ApplicationPlugin;
import org.eclipse.fordiac.ide.application.utilities.CreationPopupDialog;
import org.eclipse.fordiac.ide.application.utilities.ICreationExecutor;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.util.dnd.TransferDataSelectionFBParameter;
import org.eclipse.fordiac.ide.util.dnd.TransferDataSelectionOfFb;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ListFBCreateCommand
extends FBCreateCommand {
    private FBTypePaletteEntry[] typeList;
    private TransferDataSelectionOfFb[] selectionList;
    private AutomationSystem system;

    public ListFBCreateCommand(FBTypePaletteEntry[] type, FBNetwork parent, int x, int y) {
        super(null, parent, x, y);
        this.typeList = (FBTypePaletteEntry[])type.clone();
        this.selectionList = null;
        this.system = parent.getAutomationSystem();
    }

    public ListFBCreateCommand(TransferDataSelectionOfFb[] fbList, FBNetwork parent, int x, int y) {
        super(null, parent, x, y);
        this.typeList = null;
        this.selectionList = (TransferDataSelectionOfFb[])fbList.clone();
        this.system = parent.getAutomationSystem();
    }

    public boolean canExecute() {
        if (this.typeList != null) {
            return this.typeList.length != 0;
        }
        if (this.selectionList != null) {
            return this.selectionList.length != 0;
        }
        return false;
    }

    private void executeTransferData() {
        CreationPopupDialog pd = new CreationPopupDialog(Display.getCurrent().getActiveShell(), 540676, true, false, false, false, false, null, null, this.typeList, new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof FBTypePaletteEntry) {
                    return ((FBTypePaletteEntry)element).getLabel();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof FBTypePaletteEntry) {
                    return FordiacImage.ICON_FB.getImage();
                }
                return super.getImage(element);
            }
        }, new ICreationExecutor(){

            @Override
            public void execute(Object res) {
                if (res instanceof TransferDataSelectionOfFb) {
                    TransferDataSelectionOfFb element = (TransferDataSelectionOfFb)res;
                    List fbTypes = ListFBCreateCommand.this.system.getPalette().getTypeEntries(element.getFbTypeName());
                    if (fbTypes.size() > 0 && fbTypes.get(0) instanceof FBTypePaletteEntry) {
                        element.setTypePaletteEntry((FBTypePaletteEntry)fbTypes.get(0));
                        ListFBCreateCommand.this.paletteEntry = element.getTypePaletteEntry();
                        ListFBCreateCommand.super.execute();
                        for (TransferDataSelectionFBParameter fbParametert : element.getFbParameters()) {
                            IInterfaceElement fbInterfaceElement = ListFBCreateCommand.this.element.getInterfaceElement(fbParametert.getName());
                            if (fbInterfaceElement == null) continue;
                            Value val = fbInterfaceElement.getValue();
                            val.setValue(fbParametert.getValue());
                        }
                    } else {
                        ApplicationPlugin.statusLineErrorMessage((String)"FBType not found!");
                    }
                }
            }
        }){};
        pd.open();
    }

    private void executeFBTypePalette() {
        CreationPopupDialog pd = new CreationPopupDialog(Display.getCurrent().getActiveShell(), 540676, true, false, false, false, false, null, null, this.typeList, new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof FBTypePaletteEntry) {
                    return ((FBTypePaletteEntry)element).getLabel();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof FBTypePaletteEntry) {
                    return FordiacImage.ICON_FB.getImage();
                }
                return super.getImage(element);
            }
        }, new ICreationExecutor(){

            @Override
            public void execute(Object res) {
                if (res instanceof FBTypePaletteEntry) {
                    ListFBCreateCommand.this.paletteEntry = (FBTypePaletteEntry)res;
                    ListFBCreateCommand.super.execute();
                }
            }
        }){};
        pd.open();
    }

    public void execute() {
        if (this.selectionList != null && this.system != null) {
            this.executeTransferData();
        }
        if (this.typeList != null) {
            this.executeFBTypePalette();
        }
    }

    public boolean canUndo() {
        if (this.editor != null) {
            return super.canUndo();
        }
        return false;
    }
}

