/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.fordiac.ide.deployment.exceptions.DisconnectException;
import org.eclipse.fordiac.ide.deployment.exceptions.InvalidMgmtID;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;

public abstract class AbstractDeviceManagementCommunicationHandler {
    protected HashSet<String> fbTypes = null;
    protected HashSet<String> adapterTypes = null;
    private final ArrayList<IDeploymentListener> listeners = new ArrayList();

    public HashSet<String> getTypes() {
        return this.fbTypes;
    }

    public HashSet<String> getAdapterTypes() {
        return this.adapterTypes;
    }

    public void resetTypes() {
        this.fbTypes = null;
        this.adapterTypes = null;
    }

    public abstract void connect(String var1) throws InvalidMgmtID, UnknownHostException, IOException;

    public abstract void disconnect() throws DisconnectException;

    public abstract void sendREQ(String var1, String var2) throws IOException;

    public abstract void sendQUERY(String var1, String var2) throws IOException;

    protected void responseReceived(String response, String source) {
        for (IDeploymentListener listener : this.listeners) {
            listener.responseReceived(response, source);
        }
    }

    protected void postCommandSent(String info, String destination, String command) {
        for (IDeploymentListener listener : this.listeners) {
            listener.postCommandSent(command, info);
            listener.postCommandSent(info, destination, command);
        }
    }

    public void addDeploymentListener(IDeploymentListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDeploymentListener(IDeploymentListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

