/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.draw2d.ITransparencyFigure;

public class SetableAlphaLabel
extends Label
implements ITransparencyFigure {
    private int alpha = 255;

    public SetableAlphaLabel() {
    }

    public SetableAlphaLabel(String text) {
        super(text);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setAlpha(this.alpha);
        super.paint(graphics);
    }

    @Override
    public void setTransparency(int value) {
        this.setAlpha(value);
    }

    @Override
    public int getTransparency() {
        return this.getAlpha();
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAlpha(this.getAlpha());
        if (this.isOpaque()) {
            graphics.fillRectangle(this.getBounds());
        }
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        if (this.getIcon() != null) {
            graphics.drawImage(this.getIcon(), this.getIconLocation());
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        graphics.drawText(this.getSubStringText(), this.getTextLocation());
        graphics.translate(-bounds.x, -bounds.y);
    }
}

